/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multiset;

import java.util.Arrays;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.multiset.AbstractMultiSetTest;
import org.apache.commons.collections4.multiset.HashMultiSet;
import org.apache.commons.collections4.multiset.UnmodifiableMultiSet;

public class UnmodifiableMultiSetTest<E>
extends AbstractMultiSetTest<E> {
    public UnmodifiableMultiSetTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(UnmodifiableMultiSetTest.class);
    }

    @Override
    public MultiSet<E> makeObject() {
        return UnmodifiableMultiSet.unmodifiableMultiSet((MultiSet)new HashMultiSet());
    }

    @Override
    public MultiSet<E> makeFullCollection() {
        HashMultiSet multiset = new HashMultiSet();
        multiset.addAll(Arrays.asList(this.getFullElements()));
        return UnmodifiableMultiSet.unmodifiableMultiSet((MultiSet)multiset);
    }

    @Override
    public MultiSet<E> getCollection() {
        return super.getCollection();
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    public void testUnmodifiable() {
        UnmodifiableMultiSetTest.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        UnmodifiableMultiSetTest.assertTrue((boolean)(this.makeFullCollection() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        MultiSet<E> multiset = this.makeFullCollection();
        UnmodifiableMultiSetTest.assertSame(multiset, (Object)UnmodifiableMultiSet.unmodifiableMultiSet(multiset));
        try {
            UnmodifiableMultiSet.unmodifiableMultiSet(null);
            UnmodifiableMultiSetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4.1";
    }
}

