/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.comparators;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.comparators.AbstractComparatorTest;
import org.apache.commons.collections4.comparators.ComparableComparator;
import org.apache.commons.collections4.comparators.ReverseComparator;
import org.junit.Test;

public class ReverseComparatorTest
extends AbstractComparatorTest<Integer> {
    public ReverseComparatorTest(String testName) {
        super(testName);
    }

    @Override
    public Comparator<Integer> makeObject() {
        return new ReverseComparator(Collections.reverseOrder());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public List<Integer> getComparableObjectsOrdered() {
        LinkedList<Integer> list = new LinkedList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        list.add(5);
        return list;
    }

    @Override
    @Test
    public void testSerializeDeserializeThenCompare() throws Exception {
        ReverseComparator comp = new ReverseComparator((Comparator)new ComparableComparator());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(comp);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
        Object dest = in.readObject();
        in.close();
        ReverseComparatorTest.assertEquals((String)"obj != deserialize(serialize(obj))", (Object)comp, (Object)dest);
    }
}

