/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.HashedMap;

public class HashedMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    public HashedMapTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(HashedMapTest.class);
    }

    @Override
    public HashedMap<K, V> makeObject() {
        return new HashedMap();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    public void testClone() {
        HashedMap map = new HashedMap(10);
        map.put((Object)"1", (Object)"1");
        HashedMap cloned = map.clone();
        HashedMapTest.assertEquals((int)map.size(), (int)cloned.size());
        HashedMapTest.assertSame((Object)map.get((Object)"1"), (Object)cloned.get((Object)"1"));
    }

    public void testInternalState() {
        HashedMap map = new HashedMap(42, 0.75f);
        HashedMapTest.assertEquals((float)0.75f, (float)map.loadFactor, (float)0.1f);
        HashedMapTest.assertEquals((int)0, (int)map.size);
        HashedMapTest.assertEquals((int)64, (int)map.data.length);
        HashedMapTest.assertEquals((int)48, (int)map.threshold);
        HashedMapTest.assertEquals((int)0, (int)map.modCount);
    }

    public void testInitialCapacityZero() {
        HashedMap map = new HashedMap(0);
        HashedMapTest.assertEquals((int)1, (int)map.data.length);
    }
}

