/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileDeleteStrategyTestCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    private File getTestDirectory() {
        return this.temporaryFolder.getRoot();
    }

    @Test
    public void testDeleteNormal() throws Exception {
        File baseDir = this.getTestDirectory();
        File subDir = new File(baseDir, "test");
        Assert.assertTrue((boolean)subDir.mkdir());
        File subFile = new File(subDir, "a.txt");
        if (!subFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + subFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(subFile));){
            TestUtils.generateTestData(output, 16L);
        }
        Assert.assertTrue((boolean)subDir.exists());
        Assert.assertTrue((boolean)subFile.exists());
        try {
            FileDeleteStrategy.NORMAL.delete(subDir);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)subDir.exists());
        Assert.assertTrue((boolean)subFile.exists());
        FileDeleteStrategy.NORMAL.delete(subFile);
        Assert.assertTrue((boolean)subDir.exists());
        Assert.assertFalse((boolean)subFile.exists());
        FileDeleteStrategy.NORMAL.delete(subDir);
        Assert.assertFalse((boolean)subDir.exists());
        FileDeleteStrategy.NORMAL.delete(subDir);
        Assert.assertFalse((boolean)subDir.exists());
    }

    @Test
    public void testDeleteQuietlyNormal() throws Exception {
        File baseDir = this.getTestDirectory();
        File subDir = new File(baseDir, "test");
        Assert.assertTrue((boolean)subDir.mkdir());
        File subFile = new File(subDir, "a.txt");
        if (!subFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + subFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(subFile));){
            TestUtils.generateTestData(output, 16L);
        }
        Assert.assertTrue((boolean)subDir.exists());
        Assert.assertTrue((boolean)subFile.exists());
        Assert.assertFalse((boolean)FileDeleteStrategy.NORMAL.deleteQuietly(subDir));
        Assert.assertTrue((boolean)subDir.exists());
        Assert.assertTrue((boolean)subFile.exists());
        Assert.assertTrue((boolean)FileDeleteStrategy.NORMAL.deleteQuietly(subFile));
        Assert.assertTrue((boolean)subDir.exists());
        Assert.assertFalse((boolean)subFile.exists());
        Assert.assertTrue((boolean)FileDeleteStrategy.NORMAL.deleteQuietly(subDir));
        Assert.assertFalse((boolean)subDir.exists());
        Assert.assertTrue((boolean)FileDeleteStrategy.NORMAL.deleteQuietly(subDir));
        Assert.assertFalse((boolean)subDir.exists());
    }

    @Test
    public void testDeleteForce() throws Exception {
        File baseDir = this.getTestDirectory();
        File subDir = new File(baseDir, "test");
        Assert.assertTrue((boolean)subDir.mkdir());
        File subFile = new File(subDir, "a.txt");
        if (!subFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + subFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(subFile));){
            TestUtils.generateTestData(output, 16L);
        }
        Assert.assertTrue((boolean)subDir.exists());
        Assert.assertTrue((boolean)subFile.exists());
        FileDeleteStrategy.FORCE.delete(subDir);
        Assert.assertFalse((boolean)subDir.exists());
        Assert.assertFalse((boolean)subFile.exists());
        FileDeleteStrategy.FORCE.delete(subDir);
        Assert.assertFalse((boolean)subDir.exists());
    }

    @Test
    public void testDeleteNull() throws Exception {
        try {
            FileDeleteStrategy.NORMAL.delete(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)FileDeleteStrategy.NORMAL.deleteQuietly(null));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"FileDeleteStrategy[Normal]", (Object)FileDeleteStrategy.NORMAL.toString());
        Assert.assertEquals((Object)"FileDeleteStrategy[Force]", (Object)FileDeleteStrategy.FORCE.toString());
    }
}

