/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileUtilsDirectoryContainsTestCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File directory1;
    private File directory2;
    private File directory3;
    private File file1;
    private File file1ByRelativeDirectory2;
    private File file2;
    private File file2ByRelativeDirectory1;
    private File file3;
    private File top;

    @Before
    public void setUp() throws Exception {
        this.top = this.temporaryFolder.getRoot();
        this.directory1 = new File(this.top, "directory1");
        this.directory2 = new File(this.top, "directory2");
        this.directory3 = new File(this.directory2, "directory3");
        this.directory1.mkdir();
        this.directory2.mkdir();
        this.directory3.mkdir();
        this.file1 = new File(this.directory1, "file1");
        this.file2 = new File(this.directory2, "file2");
        this.file3 = new File(this.top, "file3");
        this.file1ByRelativeDirectory2 = new File(this.top, "directory2/../directory1/file1");
        this.file2ByRelativeDirectory1 = new File(this.top, "directory1/../directory2/file2");
        FileUtils.touch((File)this.file1);
        FileUtils.touch((File)this.file2);
        FileUtils.touch((File)this.file3);
    }

    @Test
    public void testCanonicalPath() throws IOException {
        Assert.assertTrue((boolean)FileUtils.directoryContains((File)this.directory1, (File)this.file1ByRelativeDirectory2));
        Assert.assertTrue((boolean)FileUtils.directoryContains((File)this.directory2, (File)this.file2ByRelativeDirectory1));
        Assert.assertFalse((boolean)FileUtils.directoryContains((File)this.directory1, (File)this.file2ByRelativeDirectory1));
        Assert.assertFalse((boolean)FileUtils.directoryContains((File)this.directory2, (File)this.file1ByRelativeDirectory2));
    }

    @Test
    public void testDirectoryContainsDirectory() throws IOException {
        Assert.assertTrue((boolean)FileUtils.directoryContains((File)this.top, (File)this.directory1));
        Assert.assertTrue((boolean)FileUtils.directoryContains((File)this.top, (File)this.directory2));
        Assert.assertTrue((boolean)FileUtils.directoryContains((File)this.top, (File)this.directory3));
        Assert.assertTrue((boolean)FileUtils.directoryContains((File)this.directory2, (File)this.directory3));
    }

    @Test
    public void testDirectoryContainsFile() throws IOException {
        Assert.assertTrue((boolean)FileUtils.directoryContains((File)this.directory1, (File)this.file1));
        Assert.assertTrue((boolean)FileUtils.directoryContains((File)this.directory2, (File)this.file2));
    }

    @Test
    public void testDirectoryDoesNotContainFile() throws IOException {
        Assert.assertFalse((boolean)FileUtils.directoryContains((File)this.directory1, (File)this.file2));
        Assert.assertFalse((boolean)FileUtils.directoryContains((File)this.directory2, (File)this.file1));
        Assert.assertFalse((boolean)FileUtils.directoryContains((File)this.directory1, (File)this.file3));
        Assert.assertFalse((boolean)FileUtils.directoryContains((File)this.directory2, (File)this.file3));
    }

    @Test
    public void testDirectoryDoesNotContainsDirectory() throws IOException {
        Assert.assertFalse((boolean)FileUtils.directoryContains((File)this.directory1, (File)this.top));
        Assert.assertFalse((boolean)FileUtils.directoryContains((File)this.directory2, (File)this.top));
        Assert.assertFalse((boolean)FileUtils.directoryContains((File)this.directory3, (File)this.top));
        Assert.assertFalse((boolean)FileUtils.directoryContains((File)this.directory3, (File)this.directory2));
    }

    @Test
    public void testDirectoryDoesNotExist() throws IOException {
        File dir = new File("DOESNOTEXIST");
        Assert.assertFalse((boolean)dir.exists());
        try {
            Assert.assertFalse((boolean)FileUtils.directoryContains((File)dir, (File)this.file1));
            Assert.fail((String)("Expected " + IllegalArgumentException.class.getName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSameFile() throws IOException {
        try {
            Assert.assertTrue((boolean)FileUtils.directoryContains((File)this.file1, (File)this.file1));
            Assert.fail((String)("Expected " + IllegalArgumentException.class.getName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIO466() throws IOException {
        File fooFile = new File(this.directory1.getParent(), "directory1.txt");
        Assert.assertFalse((boolean)FileUtils.directoryContains((File)this.directory1, (File)fooFile));
    }

    @Test
    public void testFileDoesNotExist() throws IOException {
        Assert.assertFalse((boolean)FileUtils.directoryContains((File)this.top, null));
        File file = new File("DOESNOTEXIST");
        Assert.assertFalse((boolean)file.exists());
        Assert.assertFalse((boolean)FileUtils.directoryContains((File)this.top, (File)file));
    }

    @Test
    public void testFileDoesNotExistBug() throws IOException {
        File file = new File(this.top, "DOESNOTEXIST");
        Assert.assertTrue((String)"Check directory exists", (boolean)this.top.exists());
        Assert.assertFalse((String)"Check file does not exist", (boolean)file.exists());
        Assert.assertFalse((String)"Direcory does not contain unrealized file", (boolean)FileUtils.directoryContains((File)this.top, (File)file));
    }

    @Test
    public void testUnrealizedContainment() throws IOException {
        File dir = new File("DOESNOTEXIST");
        File file = new File(dir, "DOESNOTEXIST2");
        Assert.assertFalse((boolean)dir.exists());
        Assert.assertFalse((boolean)file.exists());
        try {
            Assert.assertTrue((boolean)FileUtils.directoryContains((File)dir, (File)file));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

