/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.NullReader;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.io.testtools.TestUtils;
import org.apache.commons.io.testtools.YellOnCloseInputStream;
import org.apache.commons.io.testtools.YellOnFlushAndCloseOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class IOUtilsCopyTestCase {
    private static final int FILE_SIZE = 4097;
    private final byte[] inData = TestUtils.generateTestData(4097L);

    @Test
    public void testCopy_inputStreamToOutputStream() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        int count = IOUtils.copy((InputStream)in, (OutputStream)((Object)out));
        Assert.assertEquals((String)"Not all bytes were read", (long)0L, (long)((InputStream)in).available());
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
        Assert.assertEquals((long)this.inData.length, (long)count);
    }

    @Test
    public void testCopy_inputStreamToOutputStreamWithBufferSize() throws Exception {
        this.testCopy_inputStreamToOutputStreamWithBufferSize(1);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(2);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(4);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(8);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(16);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(32);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(64);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(128);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(256);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(512);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(1024);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(2048);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(4096);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(8192);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(16384);
    }

    private void testCopy_inputStreamToOutputStreamWithBufferSize(int bufferSize) throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        long count = IOUtils.copy((InputStream)in, (OutputStream)((Object)out), (int)bufferSize);
        Assert.assertEquals((String)"Not all bytes were read", (long)0L, (long)((InputStream)in).available());
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
        Assert.assertEquals((long)this.inData.length, (long)count);
    }

    @Test(expected=NullPointerException.class)
    public void testCopy_inputStreamToOutputStream_nullIn() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)null, (OutputStream)out);
    }

    @Test(expected=NullPointerException.class)
    public void testCopy_inputStreamToOutputStream_nullOut() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(this.inData);
        IOUtils.copy((InputStream)in, (OutputStream)null);
    }

    @Test
    public void testCopy_inputStreamToOutputStream_IO84() throws Exception {
        long size = 0x80000000L;
        NullInputStream in = new NullInputStream(0x80000000L);
        NullOutputStream out = new NullOutputStream();
        Assert.assertEquals((long)-1L, (long)IOUtils.copy((InputStream)in, (OutputStream)out));
        in.close();
        Assert.assertEquals((String)"copyLarge()", (long)0x80000000L, (long)IOUtils.copyLarge((InputStream)in, (OutputStream)out));
    }

    @Test
    public void testCopy_inputStreamToWriter() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.copy((InputStream)in, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assert.assertEquals((String)"Not all bytes were read", (long)0L, (long)((InputStream)in).available());
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    @Test(expected=NullPointerException.class)
    public void testCopy_inputStreamToWriter_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        IOUtils.copy((InputStream)null, (Writer)writer);
    }

    @Test(expected=NullPointerException.class)
    public void testCopy_inputStreamToWriter_nullOut() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(this.inData);
        IOUtils.copy((InputStream)in, (Writer)null);
    }

    @Test
    public void testCopy_inputStreamToWriter_Encoding() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.copy((InputStream)in, (Writer)writer, (String)"UTF8");
        out.off();
        ((Writer)writer).flush();
        Assert.assertEquals((String)"Not all bytes were read", (long)0L, (long)((InputStream)in).available());
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, "UTF8").getBytes("US-ASCII");
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, bytes));
    }

    @Test(expected=NullPointerException.class)
    public void testCopy_inputStreamToWriter_Encoding_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        IOUtils.copy(null, (Writer)writer, (String)"UTF8");
    }

    @Test(expected=NullPointerException.class)
    public void testCopy_inputStreamToWriter_Encoding_nullOut() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(this.inData);
        IOUtils.copy((InputStream)in, null, (String)"UTF8");
    }

    @Test
    public void testCopy_inputStreamToWriter_Encoding_nullEncoding() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.copy((InputStream)in, (Writer)writer, (String)null);
        out.off();
        ((Writer)writer).flush();
        Assert.assertEquals((String)"Not all bytes were read", (long)0L, (long)((InputStream)in).available());
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    @Test
    public void testCopy_readerToOutputStream() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.copy((Reader)reader, (OutputStream)((Object)out));
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    @Test(expected=NullPointerException.class)
    public void testCopy_readerToOutputStream_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.copy((Reader)null, (OutputStream)((Object)out));
    }

    @Test(expected=NullPointerException.class)
    public void testCopy_readerToOutputStream_nullOut() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        IOUtils.copy((Reader)reader, (OutputStream)null);
    }

    @Test
    public void testCopy_readerToOutputStream_Encoding() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.copy((Reader)reader, (OutputStream)((Object)out), (String)"UTF16");
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, "UTF16").getBytes("US-ASCII");
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, bytes));
    }

    @Test(expected=NullPointerException.class)
    public void testCopy_readerToOutputStream_Encoding_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.copy(null, (OutputStream)((Object)out), (String)"UTF16");
    }

    @Test(expected=NullPointerException.class)
    public void testCopy_readerToOutputStream_Encoding_nullOut() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        IOUtils.copy((Reader)reader, null, (String)"UTF16");
    }

    @Test
    public void testCopy_readerToOutputStream_Encoding_nullEncoding() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.copy((Reader)reader, (OutputStream)((Object)out), (String)null);
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    @Test
    public void testCopy_readerToWriter() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        int count = IOUtils.copy((Reader)reader, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assert.assertEquals((String)"The number of characters returned by copy is wrong", (long)this.inData.length, (long)count);
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    @Test(expected=NullPointerException.class)
    public void testCopy_readerToWriter_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        IOUtils.copy((Reader)null, (Writer)writer);
    }

    @Test(expected=NullPointerException.class)
    public void testCopy_readerToWriter_nullOut() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        IOUtils.copy((Reader)reader, (Writer)null);
    }

    @Test
    public void testCopy_readerToWriter_IO84() throws Exception {
        long size = 0x80000000L;
        NullReader reader = new NullReader(0x80000000L);
        NullWriter writer = new NullWriter();
        Assert.assertEquals((long)-1L, (long)IOUtils.copy((Reader)reader, (Writer)writer));
        reader.close();
        Assert.assertEquals((String)"copyLarge()", (long)0x80000000L, (long)IOUtils.copyLarge((Reader)reader, (Writer)writer));
    }
}

