/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.SwappedDataInputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SwappedDataInputStreamTest {
    private SwappedDataInputStream sdis;
    private byte[] bytes;

    @Before
    public void setUp() {
        this.bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
        this.sdis = new SwappedDataInputStream((InputStream)bais);
    }

    @After
    public void tearDown() {
        this.sdis = null;
    }

    @Test
    public void testReadBoolean() throws IOException {
        this.bytes = new byte[]{0, 1, 2};
        ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
        SwappedDataInputStream sdis = new SwappedDataInputStream((InputStream)bais);
        Assert.assertEquals((Object)false, (Object)sdis.readBoolean());
        Assert.assertEquals((Object)true, (Object)sdis.readBoolean());
        Assert.assertEquals((Object)true, (Object)sdis.readBoolean());
        sdis.close();
    }

    @Test
    public void testReadByte() throws IOException {
        Assert.assertEquals((long)1L, (long)this.sdis.readByte());
    }

    @Test
    public void testReadChar() throws IOException {
        Assert.assertEquals((long)513L, (long)this.sdis.readChar());
    }

    @Test
    public void testReadDouble() throws IOException {
        Assert.assertEquals((double)Double.longBitsToDouble(578437695752307201L), (double)this.sdis.readDouble(), (double)0.0);
    }

    @Test
    public void testReadFloat() throws IOException {
        Assert.assertEquals((float)Float.intBitsToFloat(67305985), (float)this.sdis.readFloat(), (float)0.0f);
    }

    @Test
    public void testReadFully() throws IOException {
        byte[] bytesIn = new byte[8];
        this.sdis.readFully(bytesIn);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((long)this.bytes[i], (long)bytesIn[i]);
        }
    }

    @Test
    public void testReadInt() throws IOException {
        Assert.assertEquals((long)67305985L, (long)this.sdis.readInt());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testReadLine() throws IOException {
        this.sdis.readLine();
        Assert.fail((String)"readLine should be unsupported. ");
    }

    @Test
    public void testReadLong() throws IOException {
        Assert.assertEquals((long)578437695752307201L, (long)this.sdis.readLong());
    }

    @Test
    public void testReadShort() throws IOException {
        Assert.assertEquals((long)513L, (long)this.sdis.readShort());
    }

    @Test
    public void testReadUnsignedByte() throws IOException {
        Assert.assertEquals((long)1L, (long)this.sdis.readUnsignedByte());
    }

    @Test
    public void testReadUnsignedShort() throws IOException {
        Assert.assertEquals((long)513L, (long)this.sdis.readUnsignedShort());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testReadUTF() throws IOException {
        this.sdis.readUTF();
        Assert.fail((String)"readUTF should be unsupported. ");
    }

    @Test
    public void testSkipBytes() throws IOException {
        this.sdis.skipBytes(4);
        Assert.assertEquals((long)134678021L, (long)this.sdis.readInt());
    }
}

