/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import java.util.regex.Pattern;
import org.apache.commons.io.serialization.RegexpClassNameMatcher;
import org.junit.Assert;
import org.junit.Test;

public class RegexpClassNameMatcherTest {
    @Test
    public void testSimplePatternFromString() {
        RegexpClassNameMatcher ca = new RegexpClassNameMatcher("foo.*");
        Assert.assertTrue((boolean)ca.matches("foo.should.match"));
        Assert.assertFalse((boolean)ca.matches("bar.should.not.match"));
    }

    @Test
    public void testSimplePatternFromPattern() {
        RegexpClassNameMatcher ca = new RegexpClassNameMatcher(Pattern.compile("foo.*"));
        Assert.assertTrue((boolean)ca.matches("foo.should.match"));
        Assert.assertFalse((boolean)ca.matches("bar.should.not.match"));
    }

    @Test
    public void testOrPattern() {
        RegexpClassNameMatcher ca = new RegexpClassNameMatcher("foo.*|bar.*");
        Assert.assertTrue((boolean)ca.matches("foo.should.match"));
        Assert.assertTrue((boolean)ca.matches("bar.should.match"));
        Assert.assertFalse((boolean)ca.matches("zoo.should.not.match"));
    }

    @Test(expected=NullPointerException.class)
    public void testNullStringPattern() {
        new RegexpClassNameMatcher((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullPatternPattern() {
        new RegexpClassNameMatcher((Pattern)null);
    }
}

