/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.UUID;
import org.apache.commons.lang3.Conversion;
import org.junit.Assert;
import org.junit.Test;

public class ConversionTest {
    @Test
    public void testHexDigitToInt() {
        Assert.assertEquals((long)0L, (long)Conversion.hexDigitToInt((char)'0'));
        Assert.assertEquals((long)1L, (long)Conversion.hexDigitToInt((char)'1'));
        Assert.assertEquals((long)2L, (long)Conversion.hexDigitToInt((char)'2'));
        Assert.assertEquals((long)3L, (long)Conversion.hexDigitToInt((char)'3'));
        Assert.assertEquals((long)4L, (long)Conversion.hexDigitToInt((char)'4'));
        Assert.assertEquals((long)5L, (long)Conversion.hexDigitToInt((char)'5'));
        Assert.assertEquals((long)6L, (long)Conversion.hexDigitToInt((char)'6'));
        Assert.assertEquals((long)7L, (long)Conversion.hexDigitToInt((char)'7'));
        Assert.assertEquals((long)8L, (long)Conversion.hexDigitToInt((char)'8'));
        Assert.assertEquals((long)9L, (long)Conversion.hexDigitToInt((char)'9'));
        Assert.assertEquals((long)10L, (long)Conversion.hexDigitToInt((char)'A'));
        Assert.assertEquals((long)10L, (long)Conversion.hexDigitToInt((char)'a'));
        Assert.assertEquals((long)11L, (long)Conversion.hexDigitToInt((char)'B'));
        Assert.assertEquals((long)11L, (long)Conversion.hexDigitToInt((char)'b'));
        Assert.assertEquals((long)12L, (long)Conversion.hexDigitToInt((char)'C'));
        Assert.assertEquals((long)12L, (long)Conversion.hexDigitToInt((char)'c'));
        Assert.assertEquals((long)13L, (long)Conversion.hexDigitToInt((char)'D'));
        Assert.assertEquals((long)13L, (long)Conversion.hexDigitToInt((char)'d'));
        Assert.assertEquals((long)14L, (long)Conversion.hexDigitToInt((char)'E'));
        Assert.assertEquals((long)14L, (long)Conversion.hexDigitToInt((char)'e'));
        Assert.assertEquals((long)15L, (long)Conversion.hexDigitToInt((char)'F'));
        Assert.assertEquals((long)15L, (long)Conversion.hexDigitToInt((char)'f'));
        try {
            Conversion.hexDigitToInt((char)'G');
            Assert.fail((String)("Thrown " + IllegalArgumentException.class.getName() + " expected"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testHexDigitMsb0ToInt() {
        Assert.assertEquals((long)0L, (long)Conversion.hexDigitMsb0ToInt((char)'0'));
        Assert.assertEquals((long)8L, (long)Conversion.hexDigitMsb0ToInt((char)'1'));
        Assert.assertEquals((long)4L, (long)Conversion.hexDigitMsb0ToInt((char)'2'));
        Assert.assertEquals((long)12L, (long)Conversion.hexDigitMsb0ToInt((char)'3'));
        Assert.assertEquals((long)2L, (long)Conversion.hexDigitMsb0ToInt((char)'4'));
        Assert.assertEquals((long)10L, (long)Conversion.hexDigitMsb0ToInt((char)'5'));
        Assert.assertEquals((long)6L, (long)Conversion.hexDigitMsb0ToInt((char)'6'));
        Assert.assertEquals((long)14L, (long)Conversion.hexDigitMsb0ToInt((char)'7'));
        Assert.assertEquals((long)1L, (long)Conversion.hexDigitMsb0ToInt((char)'8'));
        Assert.assertEquals((long)9L, (long)Conversion.hexDigitMsb0ToInt((char)'9'));
        Assert.assertEquals((long)5L, (long)Conversion.hexDigitMsb0ToInt((char)'A'));
        Assert.assertEquals((long)5L, (long)Conversion.hexDigitMsb0ToInt((char)'a'));
        Assert.assertEquals((long)13L, (long)Conversion.hexDigitMsb0ToInt((char)'B'));
        Assert.assertEquals((long)13L, (long)Conversion.hexDigitMsb0ToInt((char)'b'));
        Assert.assertEquals((long)3L, (long)Conversion.hexDigitMsb0ToInt((char)'C'));
        Assert.assertEquals((long)3L, (long)Conversion.hexDigitMsb0ToInt((char)'c'));
        Assert.assertEquals((long)11L, (long)Conversion.hexDigitMsb0ToInt((char)'D'));
        Assert.assertEquals((long)11L, (long)Conversion.hexDigitMsb0ToInt((char)'d'));
        Assert.assertEquals((long)7L, (long)Conversion.hexDigitMsb0ToInt((char)'E'));
        Assert.assertEquals((long)7L, (long)Conversion.hexDigitMsb0ToInt((char)'e'));
        Assert.assertEquals((long)15L, (long)Conversion.hexDigitMsb0ToInt((char)'F'));
        Assert.assertEquals((long)15L, (long)Conversion.hexDigitMsb0ToInt((char)'f'));
        try {
            Conversion.hexDigitMsb0ToInt((char)'G');
            Assert.fail((String)("Thrown " + IllegalArgumentException.class.getName() + " expected"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testHexDigitToBinary() {
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, false, false}, Conversion.hexDigitToBinary((char)'0'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, false, false}, Conversion.hexDigitToBinary((char)'1'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, true, false, false}, Conversion.hexDigitToBinary((char)'2'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, false, false}, Conversion.hexDigitToBinary((char)'3'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, true, false}, Conversion.hexDigitToBinary((char)'4'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, true, false}, Conversion.hexDigitToBinary((char)'5'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, true, true, false}, Conversion.hexDigitToBinary((char)'6'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, false}, Conversion.hexDigitToBinary((char)'7'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, false, true}, Conversion.hexDigitToBinary((char)'8'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, false, true}, Conversion.hexDigitToBinary((char)'9'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, true, false, true}, Conversion.hexDigitToBinary((char)'A'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, true, false, true}, Conversion.hexDigitToBinary((char)'a'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, false, true}, Conversion.hexDigitToBinary((char)'B'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, false, true}, Conversion.hexDigitToBinary((char)'b'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, true, true}, Conversion.hexDigitToBinary((char)'C'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, true, true}, Conversion.hexDigitToBinary((char)'c'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, true, true}, Conversion.hexDigitToBinary((char)'D'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, true, true}, Conversion.hexDigitToBinary((char)'d'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, true, true, true}, Conversion.hexDigitToBinary((char)'E'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, true, true, true}, Conversion.hexDigitToBinary((char)'e'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, true}, Conversion.hexDigitToBinary((char)'F'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, true}, Conversion.hexDigitToBinary((char)'f'));
        try {
            Conversion.hexDigitToBinary((char)'G');
            Assert.fail((String)("Thrown " + IllegalArgumentException.class.getName() + " expected"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testHexDigitMsb0ToBinary() {
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, false, false}, Conversion.hexDigitMsb0ToBinary((char)'0'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, false, true}, Conversion.hexDigitMsb0ToBinary((char)'1'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, true, false}, Conversion.hexDigitMsb0ToBinary((char)'2'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, true, true}, Conversion.hexDigitMsb0ToBinary((char)'3'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, true, false, false}, Conversion.hexDigitMsb0ToBinary((char)'4'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, true, false, true}, Conversion.hexDigitMsb0ToBinary((char)'5'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, true, true, false}, Conversion.hexDigitMsb0ToBinary((char)'6'));
        ConversionTest.assertBinaryEquals(new boolean[]{false, true, true, true}, Conversion.hexDigitMsb0ToBinary((char)'7'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, false, false}, Conversion.hexDigitMsb0ToBinary((char)'8'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, false, true}, Conversion.hexDigitMsb0ToBinary((char)'9'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, true, false}, Conversion.hexDigitMsb0ToBinary((char)'A'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, true, false}, Conversion.hexDigitMsb0ToBinary((char)'a'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, true, true}, Conversion.hexDigitMsb0ToBinary((char)'B'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, true, true}, Conversion.hexDigitMsb0ToBinary((char)'b'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, false, false}, Conversion.hexDigitMsb0ToBinary((char)'C'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, false, false}, Conversion.hexDigitMsb0ToBinary((char)'c'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, false, true}, Conversion.hexDigitMsb0ToBinary((char)'D'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, false, true}, Conversion.hexDigitMsb0ToBinary((char)'d'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, false}, Conversion.hexDigitMsb0ToBinary((char)'E'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, false}, Conversion.hexDigitMsb0ToBinary((char)'e'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, true}, Conversion.hexDigitMsb0ToBinary((char)'F'));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, true}, Conversion.hexDigitMsb0ToBinary((char)'f'));
        try {
            Conversion.hexDigitMsb0ToBinary((char)'G');
            Assert.fail((String)("Thrown " + IllegalArgumentException.class.getName() + " expected"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBinaryToHexDigit() {
        Assert.assertEquals((long)48L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, false, false, false}));
        Assert.assertEquals((long)49L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, false, false, false}));
        Assert.assertEquals((long)50L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, true, false, false}));
        Assert.assertEquals((long)51L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, true, false, false}));
        Assert.assertEquals((long)52L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, false, true, false}));
        Assert.assertEquals((long)53L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, false, true, false}));
        Assert.assertEquals((long)54L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, true, true, false}));
        Assert.assertEquals((long)55L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, true, true, false}));
        Assert.assertEquals((long)56L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, false, false, true}));
        Assert.assertEquals((long)57L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, false, false, true}));
        Assert.assertEquals((long)97L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, true, false, true}));
        Assert.assertEquals((long)98L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, true, false, true}));
        Assert.assertEquals((long)99L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, false, true, true}));
        Assert.assertEquals((long)100L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, false, true, true}));
        Assert.assertEquals((long)101L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{false, true, true, true}));
        Assert.assertEquals((long)102L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, true, true, true}));
        Assert.assertEquals((long)49L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{true}));
        Assert.assertEquals((long)102L, (long)Conversion.binaryToHexDigit((boolean[])new boolean[]{true, true, true, true, true}));
        try {
            Conversion.binaryToHexDigit((boolean[])new boolean[0]);
            Assert.fail((String)("Thrown " + IllegalArgumentException.class.getName() + " expected"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBinaryToHexDigit_2args() {
        boolean[] shortArray = new boolean[]{false, true, true};
        Assert.assertEquals((long)54L, (long)Conversion.binaryToHexDigit((boolean[])shortArray, (int)0));
        Assert.assertEquals((long)51L, (long)Conversion.binaryToHexDigit((boolean[])shortArray, (int)1));
        Assert.assertEquals((long)49L, (long)Conversion.binaryToHexDigit((boolean[])shortArray, (int)2));
        boolean[] longArray = new boolean[]{true, false, true, false, false, true, true};
        Assert.assertEquals((long)53L, (long)Conversion.binaryToHexDigit((boolean[])longArray, (int)0));
        Assert.assertEquals((long)50L, (long)Conversion.binaryToHexDigit((boolean[])longArray, (int)1));
        Assert.assertEquals((long)57L, (long)Conversion.binaryToHexDigit((boolean[])longArray, (int)2));
        Assert.assertEquals((long)99L, (long)Conversion.binaryToHexDigit((boolean[])longArray, (int)3));
        Assert.assertEquals((long)54L, (long)Conversion.binaryToHexDigit((boolean[])longArray, (int)4));
        Assert.assertEquals((long)51L, (long)Conversion.binaryToHexDigit((boolean[])longArray, (int)5));
        Assert.assertEquals((long)49L, (long)Conversion.binaryToHexDigit((boolean[])longArray, (int)6));
    }

    @Test
    public void testBinaryToHexDigitMsb0_bits() {
        Assert.assertEquals((long)48L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, false, false, false}));
        Assert.assertEquals((long)49L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, false, false, true}));
        Assert.assertEquals((long)50L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, false, true, false}));
        Assert.assertEquals((long)51L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, false, true, true}));
        Assert.assertEquals((long)52L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, true, false, false}));
        Assert.assertEquals((long)53L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, true, false, true}));
        Assert.assertEquals((long)54L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, true, true, false}));
        Assert.assertEquals((long)55L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{false, true, true, true}));
        Assert.assertEquals((long)56L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, false, false, false}));
        Assert.assertEquals((long)57L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, false, false, true}));
        Assert.assertEquals((long)97L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, false, true, false}));
        Assert.assertEquals((long)98L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, false, true, true}));
        Assert.assertEquals((long)99L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, true, false, false}));
        Assert.assertEquals((long)100L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, true, false, true}));
        Assert.assertEquals((long)101L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, true, true, false}));
        Assert.assertEquals((long)102L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[]{true, true, true, true}));
        try {
            Conversion.binaryToHexDigitMsb0_4bits((boolean[])new boolean[0]);
            Assert.fail((String)("Thrown " + IllegalArgumentException.class.getName() + " expected"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBinaryToHexDigitMsb0_4bits_2args() {
        boolean[] shortArray = new boolean[]{true, true, false, true};
        Assert.assertEquals((long)100L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])shortArray, (int)0));
        boolean[] longArray = new boolean[]{true, false, true, false, false, true, true};
        Assert.assertEquals((long)97L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])longArray, (int)0));
        Assert.assertEquals((long)52L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])longArray, (int)1));
        Assert.assertEquals((long)57L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])longArray, (int)2));
        Assert.assertEquals((long)51L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])longArray, (int)3));
        boolean[] maxLengthArray = new boolean[]{true, false, true, false, false, true, true, true};
        Assert.assertEquals((long)97L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])maxLengthArray, (int)0));
        Assert.assertEquals((long)52L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])maxLengthArray, (int)1));
        Assert.assertEquals((long)57L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])maxLengthArray, (int)2));
        Assert.assertEquals((long)51L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])maxLengthArray, (int)3));
        Assert.assertEquals((long)55L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])maxLengthArray, (int)4));
        boolean[] javaDocCheck = new boolean[]{true, false, false, true, true, false, true, false};
        Assert.assertEquals((long)100L, (long)Conversion.binaryToHexDigitMsb0_4bits((boolean[])javaDocCheck, (int)3));
    }

    @Test
    public void testBinaryBeMsb0ToHexDigit() {
        Assert.assertEquals((long)48L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, false, false, false}));
        Assert.assertEquals((long)49L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, false, false, true}));
        Assert.assertEquals((long)50L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, false, true, false}));
        Assert.assertEquals((long)51L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, false, true, true}));
        Assert.assertEquals((long)52L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, true, false, false}));
        Assert.assertEquals((long)53L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, true, false, true}));
        Assert.assertEquals((long)54L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, true, true, false}));
        Assert.assertEquals((long)55L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{false, true, true, true}));
        Assert.assertEquals((long)56L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, false, false, false}));
        Assert.assertEquals((long)57L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, false, false, true}));
        Assert.assertEquals((long)97L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, false, true, false}));
        Assert.assertEquals((long)98L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, false, true, true}));
        Assert.assertEquals((long)99L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, true, false, false}));
        Assert.assertEquals((long)100L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, true, false, true}));
        Assert.assertEquals((long)101L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, true, true, false}));
        Assert.assertEquals((long)102L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, true, true, true}));
        Assert.assertEquals((long)52L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false}));
        try {
            Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[0]);
            Assert.fail((String)("Thrown " + IllegalArgumentException.class.getName() + " expected"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBinaryBeMsb0ToHexDigit_2args() {
        Assert.assertEquals((long)53L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])new boolean[]{true, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false}, (int)2));
        boolean[] shortArray = new boolean[]{true, true, false};
        Assert.assertEquals((long)54L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray, (int)0));
        Assert.assertEquals((long)51L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray, (int)1));
        Assert.assertEquals((long)49L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray, (int)2));
        boolean[] shortArray2 = new boolean[]{true, true, true, false, false, true, false, true};
        Assert.assertEquals((long)53L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)0));
        Assert.assertEquals((long)50L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)1));
        Assert.assertEquals((long)57L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)2));
        Assert.assertEquals((long)99L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)3));
        Assert.assertEquals((long)101L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)4));
        Assert.assertEquals((long)55L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)5));
        Assert.assertEquals((long)51L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)6));
        Assert.assertEquals((long)49L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])shortArray2, (int)7));
        boolean[] multiBytesArray = new boolean[]{true, true, false, false, true, false, true, false, true, true, true, false, false, true, false, true};
        Assert.assertEquals((long)53L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)0));
        Assert.assertEquals((long)50L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)1));
        Assert.assertEquals((long)57L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)2));
        Assert.assertEquals((long)99L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)3));
        Assert.assertEquals((long)101L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)4));
        Assert.assertEquals((long)55L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)5));
        Assert.assertEquals((long)98L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)6));
        Assert.assertEquals((long)53L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)7));
        Assert.assertEquals((long)97L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)8));
        Assert.assertEquals((long)53L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)9));
        Assert.assertEquals((long)50L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)10));
        Assert.assertEquals((long)57L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)11));
        Assert.assertEquals((long)99L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)12));
        Assert.assertEquals((long)54L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)13));
        Assert.assertEquals((long)51L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)14));
        Assert.assertEquals((long)49L, (long)Conversion.binaryBeMsb0ToHexDigit((boolean[])multiBytesArray, (int)15));
    }

    @Test
    public void testIntToHexDigit() {
        Assert.assertEquals((long)48L, (long)Conversion.intToHexDigit((int)0));
        Assert.assertEquals((long)49L, (long)Conversion.intToHexDigit((int)1));
        Assert.assertEquals((long)50L, (long)Conversion.intToHexDigit((int)2));
        Assert.assertEquals((long)51L, (long)Conversion.intToHexDigit((int)3));
        Assert.assertEquals((long)52L, (long)Conversion.intToHexDigit((int)4));
        Assert.assertEquals((long)53L, (long)Conversion.intToHexDigit((int)5));
        Assert.assertEquals((long)54L, (long)Conversion.intToHexDigit((int)6));
        Assert.assertEquals((long)55L, (long)Conversion.intToHexDigit((int)7));
        Assert.assertEquals((long)56L, (long)Conversion.intToHexDigit((int)8));
        Assert.assertEquals((long)57L, (long)Conversion.intToHexDigit((int)9));
        Assert.assertEquals((long)97L, (long)Conversion.intToHexDigit((int)10));
        Assert.assertEquals((long)98L, (long)Conversion.intToHexDigit((int)11));
        Assert.assertEquals((long)99L, (long)Conversion.intToHexDigit((int)12));
        Assert.assertEquals((long)100L, (long)Conversion.intToHexDigit((int)13));
        Assert.assertEquals((long)101L, (long)Conversion.intToHexDigit((int)14));
        Assert.assertEquals((long)102L, (long)Conversion.intToHexDigit((int)15));
        try {
            Conversion.intToHexDigit((int)16);
            Assert.fail((String)("Thrown " + IllegalArgumentException.class.getName() + " expected"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIntToHexDigitMsb0() {
        Assert.assertEquals((long)48L, (long)Conversion.intToHexDigitMsb0((int)0));
        Assert.assertEquals((long)56L, (long)Conversion.intToHexDigitMsb0((int)1));
        Assert.assertEquals((long)52L, (long)Conversion.intToHexDigitMsb0((int)2));
        Assert.assertEquals((long)99L, (long)Conversion.intToHexDigitMsb0((int)3));
        Assert.assertEquals((long)50L, (long)Conversion.intToHexDigitMsb0((int)4));
        Assert.assertEquals((long)97L, (long)Conversion.intToHexDigitMsb0((int)5));
        Assert.assertEquals((long)54L, (long)Conversion.intToHexDigitMsb0((int)6));
        Assert.assertEquals((long)101L, (long)Conversion.intToHexDigitMsb0((int)7));
        Assert.assertEquals((long)49L, (long)Conversion.intToHexDigitMsb0((int)8));
        Assert.assertEquals((long)57L, (long)Conversion.intToHexDigitMsb0((int)9));
        Assert.assertEquals((long)53L, (long)Conversion.intToHexDigitMsb0((int)10));
        Assert.assertEquals((long)100L, (long)Conversion.intToHexDigitMsb0((int)11));
        Assert.assertEquals((long)51L, (long)Conversion.intToHexDigitMsb0((int)12));
        Assert.assertEquals((long)98L, (long)Conversion.intToHexDigitMsb0((int)13));
        Assert.assertEquals((long)55L, (long)Conversion.intToHexDigitMsb0((int)14));
        Assert.assertEquals((long)102L, (long)Conversion.intToHexDigitMsb0((int)15));
        try {
            Conversion.intToHexDigitMsb0((int)16);
            Assert.fail((String)("Thrown " + IllegalArgumentException.class.getName() + " expected"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static String dbgPrint(boolean[] src) {
        StringBuilder sb = new StringBuilder();
        for (boolean e : src) {
            if (e) {
                sb.append("1,");
                continue;
            }
            sb.append("0,");
        }
        String out = sb.toString();
        return out.substring(0, out.length() - 1);
    }

    static void assertBinaryEquals(boolean[] expected, boolean[] actual) {
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            try {
                Assert.assertEquals((Object)expected[i], (Object)actual[i]);
                continue;
            }
            catch (Throwable e) {
                String msg = "Mismatch at index " + i + " between:\n" + ConversionTest.dbgPrint(expected) + " and\n" + ConversionTest.dbgPrint(actual);
                Assert.fail((String)(msg + "\n" + e.getMessage()));
            }
        }
    }

    @Test
    public void testIntArrayToLong() {
        int[] src = new int[]{-839782207, 252851286, 0x78000000};
        Assert.assertEquals((long)0L, (long)Conversion.intArrayToLong((int[])src, (int)0, (long)0L, (int)0, (int)0));
        Assert.assertEquals((long)0L, (long)Conversion.intArrayToLong((int[])src, (int)1, (long)0L, (int)0, (int)0));
        Assert.assertEquals((long)3455185089L, (long)Conversion.intArrayToLong((int[])src, (int)0, (long)0L, (int)0, (int)1));
        Assert.assertEquals((long)1085988007576727745L, (long)Conversion.intArrayToLong((int[])src, (int)0, (long)0L, (int)0, (int)2));
        Assert.assertEquals((long)252851286L, (long)Conversion.intArrayToLong((int[])src, (int)1, (long)0L, (int)0, (int)1));
        Assert.assertEquals((long)1311768467463790320L, (long)Conversion.intArrayToLong((int[])src, (int)0, (long)1311768467463790320L, (int)0, (int)0));
        Assert.assertEquals((long)1311768466880987136L, (long)Conversion.intArrayToLong((int[])src, (int)2, (long)1311768467463790320L, (int)0, (int)1));
    }

    @Test
    public void testShortArrayToLong() {
        short[] src = new short[]{-12815, -3903, 3858, 13398, 30720};
        Assert.assertEquals((long)0L, (long)Conversion.shortArrayToLong((short[])src, (int)0, (long)0L, (int)0, (int)0));
        Assert.assertEquals((long)52721L, (long)Conversion.shortArrayToLong((short[])src, (int)0, (long)0L, (int)0, (int)1));
        Assert.assertEquals((long)4039233009L, (long)Conversion.shortArrayToLong((short[])src, (int)0, (long)0L, (int)0, (int)2));
        Assert.assertEquals((long)8646968828776083649L, (long)Conversion.shortArrayToLong((short[])src, (int)1, (long)0L, (int)0, (int)4));
        Assert.assertEquals((long)1311768467463790320L, (long)Conversion.shortArrayToLong((short[])src, (int)0, (long)1311768467463790320L, (int)0, (int)0));
        Assert.assertEquals((long)1311768833995628272L, (long)Conversion.shortArrayToLong((short[])src, (int)0, (long)1311768467463790320L, (int)24, (int)1));
        Assert.assertEquals((long)1311805333745098480L, (long)Conversion.shortArrayToLong((short[])src, (int)3, (long)1311768467463790320L, (int)16, (int)2));
    }

    @Test
    public void testByteArrayToLong() {
        byte[] src = new byte[]{-51, -15, -16, -63, 15, 18, 52, 86, 120};
        Assert.assertEquals((long)0L, (long)Conversion.byteArrayToLong((byte[])src, (int)0, (long)0L, (int)0, (int)0));
        Assert.assertEquals((long)205L, (long)Conversion.byteArrayToLong((byte[])src, (int)0, (long)0L, (int)0, (int)1));
        Assert.assertEquals((long)3253793229L, (long)Conversion.byteArrayToLong((byte[])src, (int)0, (long)0L, (int)0, (int)4));
        Assert.assertEquals((long)264368369L, (long)Conversion.byteArrayToLong((byte[])src, (int)1, (long)0L, (int)0, (int)4));
        Assert.assertEquals((long)1311768467463790320L, (long)Conversion.byteArrayToLong((byte[])src, (int)0, (long)1311768467463790320L, (int)0, (int)0));
        Assert.assertEquals((long)1311768468319428336L, (long)Conversion.byteArrayToLong((byte[])src, (int)0, (long)1311768467463790320L, (int)24, (int)1));
        Assert.assertEquals((long)1311768467459299056L, (long)Conversion.byteArrayToLong((byte[])src, (int)7, (long)1311768467463790320L, (int)8, (int)2));
    }

    @Test
    public void testShortArrayToInt() {
        short[] src = new short[]{-12815, -3903, 3858, 13398, 30720};
        Assert.assertEquals((long)0L, (long)Conversion.shortArrayToInt((short[])src, (int)0, (int)0, (int)0, (int)0));
        Assert.assertEquals((long)52721L, (long)Conversion.shortArrayToInt((short[])src, (int)0, (int)0, (int)0, (int)1));
        Assert.assertEquals((long)-255734287L, (long)Conversion.shortArrayToInt((short[])src, (int)0, (int)0, (int)0, (int)2));
        Assert.assertEquals((long)252899521L, (long)Conversion.shortArrayToInt((short[])src, (int)1, (int)0, (int)0, (int)2));
        Assert.assertEquals((long)305419896L, (long)Conversion.shortArrayToInt((short[])src, (int)0, (int)305419896, (int)0, (int)0));
        Assert.assertEquals((long)-839821704L, (long)Conversion.shortArrayToInt((short[])src, (int)0, (int)305419896, (int)16, (int)1));
    }

    @Test
    public void testByteArrayToInt() {
        byte[] src = new byte[]{-51, -15, -16, -63, 15, 18, 52, 86, 120};
        Assert.assertEquals((long)0L, (long)Conversion.byteArrayToInt((byte[])src, (int)0, (int)0, (int)0, (int)0));
        Assert.assertEquals((long)205L, (long)Conversion.byteArrayToInt((byte[])src, (int)0, (int)0, (int)0, (int)1));
        Assert.assertEquals((long)-1041174067L, (long)Conversion.byteArrayToInt((byte[])src, (int)0, (int)0, (int)0, (int)4));
        Assert.assertEquals((long)264368369L, (long)Conversion.byteArrayToInt((byte[])src, (int)1, (int)0, (int)0, (int)4));
        Assert.assertEquals((long)305419896L, (long)Conversion.byteArrayToInt((byte[])src, (int)0, (int)305419896, (int)0, (int)0));
        Assert.assertEquals((long)-852208008L, (long)Conversion.byteArrayToInt((byte[])src, (int)0, (int)305419896, (int)24, (int)1));
    }

    @Test
    public void testByteArrayToShort() {
        byte[] src = new byte[]{-51, -15, -16, -63, 15, 18, 52, 86, 120};
        Assert.assertEquals((long)0L, (long)Conversion.byteArrayToShort((byte[])src, (int)0, (short)0, (int)0, (int)0));
        Assert.assertEquals((long)205L, (long)Conversion.byteArrayToShort((byte[])src, (int)0, (short)0, (int)0, (int)1));
        Assert.assertEquals((long)-3635L, (long)Conversion.byteArrayToShort((byte[])src, (int)0, (short)0, (int)0, (int)2));
        Assert.assertEquals((long)-3855L, (long)Conversion.byteArrayToShort((byte[])src, (int)1, (short)0, (int)0, (int)2));
        Assert.assertEquals((long)4660L, (long)Conversion.byteArrayToShort((byte[])src, (int)0, (short)4660, (int)0, (int)0));
        Assert.assertEquals((long)-13004L, (long)Conversion.byteArrayToShort((byte[])src, (int)0, (short)4660, (int)8, (int)1));
    }

    @Test
    public void testHexToLong() {
        String src = "CDF1F0C10F12345678";
        Assert.assertEquals((long)0L, (long)Conversion.hexToLong((String)"CDF1F0C10F12345678", (int)0, (long)0L, (int)0, (int)0));
        Assert.assertEquals((long)12L, (long)Conversion.hexToLong((String)"CDF1F0C10F12345678", (int)0, (long)0L, (int)0, (int)1));
        Assert.assertEquals((long)470753244L, (long)Conversion.hexToLong((String)"CDF1F0C10F12345678", (int)0, (long)0L, (int)0, (int)8));
        Assert.assertEquals((long)29422077L, (long)Conversion.hexToLong((String)"CDF1F0C10F12345678", (int)1, (long)0L, (int)0, (int)8));
        Assert.assertEquals((long)1311768471490322160L, (long)Conversion.hexToLong((String)"CDF1F0C10F12345678", (int)0, (long)1311768471490322160L, (int)0, (int)0));
        Assert.assertEquals((long)1311768466859810544L, (long)Conversion.hexToLong((String)"CDF1F0C10F12345678", (int)15, (long)1311768471490322160L, (int)24, (int)3));
    }

    @Test
    public void testHexToInt() {
        String src = "CDF1F0C10F12345678";
        Assert.assertEquals((long)0L, (long)Conversion.hexToInt((String)"CDF1F0C10F12345678", (int)0, (int)0, (int)0, (int)0));
        Assert.assertEquals((long)12L, (long)Conversion.hexToInt((String)"CDF1F0C10F12345678", (int)0, (int)0, (int)0, (int)1));
        Assert.assertEquals((long)470753244L, (long)Conversion.hexToInt((String)"CDF1F0C10F12345678", (int)0, (int)0, (int)0, (int)8));
        Assert.assertEquals((long)29422077L, (long)Conversion.hexToInt((String)"CDF1F0C10F12345678", (int)1, (int)0, (int)0, (int)8));
        Assert.assertEquals((long)305419897L, (long)Conversion.hexToInt((String)"CDF1F0C10F12345678", (int)0, (int)305419897, (int)0, (int)0));
        Assert.assertEquals((long)-2023467399L, (long)Conversion.hexToInt((String)"CDF1F0C10F12345678", (int)15, (int)305419897, (int)20, (int)3));
    }

    @Test
    public void testHexToShort() {
        String src = "CDF1F0C10F12345678";
        Assert.assertEquals((long)0L, (long)Conversion.hexToShort((String)"CDF1F0C10F12345678", (int)0, (short)0, (int)0, (int)0));
        Assert.assertEquals((long)12L, (long)Conversion.hexToShort((String)"CDF1F0C10F12345678", (int)0, (short)0, (int)0, (int)1));
        Assert.assertEquals((long)8156L, (long)Conversion.hexToShort((String)"CDF1F0C10F12345678", (int)0, (short)0, (int)0, (int)4));
        Assert.assertEquals((long)-3587L, (long)Conversion.hexToShort((String)"CDF1F0C10F12345678", (int)1, (short)0, (int)0, (int)4));
        Assert.assertEquals((long)4660L, (long)Conversion.hexToShort((String)"CDF1F0C10F12345678", (int)0, (short)4660, (int)0, (int)0));
        Assert.assertEquals((long)-30876L, (long)Conversion.hexToShort((String)"CDF1F0C10F12345678", (int)15, (short)4660, (int)4, (int)3));
    }

    @Test
    public void testHexToByte() {
        String src = "CDF1F0C10F12345678";
        Assert.assertEquals((long)0L, (long)Conversion.hexToByte((String)"CDF1F0C10F12345678", (int)0, (byte)0, (int)0, (int)0));
        Assert.assertEquals((long)12L, (long)Conversion.hexToByte((String)"CDF1F0C10F12345678", (int)0, (byte)0, (int)0, (int)1));
        Assert.assertEquals((long)-36L, (long)Conversion.hexToByte((String)"CDF1F0C10F12345678", (int)0, (byte)0, (int)0, (int)2));
        Assert.assertEquals((long)-3L, (long)Conversion.hexToByte((String)"CDF1F0C10F12345678", (int)1, (byte)0, (int)0, (int)2));
        Assert.assertEquals((long)52L, (long)Conversion.hexToByte((String)"CDF1F0C10F12345678", (int)0, (byte)52, (int)0, (int)0));
        Assert.assertEquals((long)-124L, (long)Conversion.hexToByte((String)"CDF1F0C10F12345678", (int)17, (byte)52, (int)4, (int)1));
    }

    @Test
    public void testBinaryToLong() {
        boolean[] src = new boolean[]{false, false, true, true, true, false, true, true, true, true, true, true, true, false, false, false, true, true, true, true, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, false, true, false, false, true, true, false, false, false, false, true, false, true, false, true, false, false, true, true, false, true, true, true, false, false, false, false, true};
        Assert.assertEquals((long)0L, (long)Conversion.binaryToLong((boolean[])src, (int)0, (long)0L, (int)0, (int)0));
        Assert.assertEquals((long)12L, (long)Conversion.binaryToLong((boolean[])src, (int)0, (long)0L, (int)0, (int)4));
        Assert.assertEquals((long)470753244L, (long)Conversion.binaryToLong((boolean[])src, (int)0, (long)0L, (int)0, (int)32));
        Assert.assertEquals((long)29422077L, (long)Conversion.binaryToLong((boolean[])src, (int)4, (long)0L, (int)0, (int)32));
        Assert.assertEquals((long)1311768471490322160L, (long)Conversion.binaryToLong((boolean[])src, (int)0, (long)1311768471490322160L, (int)0, (int)0));
        Assert.assertEquals((long)1311768466859810544L, (long)Conversion.binaryToLong((boolean[])src, (int)60, (long)1311768471490322160L, (int)24, (int)12));
    }

    @Test
    public void testBinaryToInt() {
        boolean[] src = new boolean[]{false, false, true, true, true, false, true, true, true, true, true, true, true, false, false, false, true, true, true, true, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, false, true, false, false, true, true, false, false, false, false, true, false, true, false, true, false, false, true, true, false, true, true, true, false, false, false, false, true};
        Assert.assertEquals((long)0L, (long)Conversion.binaryToInt((boolean[])src, (int)0, (int)0, (int)0, (int)0));
        Assert.assertEquals((long)12L, (long)Conversion.binaryToInt((boolean[])src, (int)0, (int)0, (int)0, (int)4));
        Assert.assertEquals((long)470753244L, (long)Conversion.binaryToInt((boolean[])src, (int)0, (int)0, (int)0, (int)32));
        Assert.assertEquals((long)29422077L, (long)Conversion.binaryToInt((boolean[])src, (int)4, (int)0, (int)0, (int)32));
        Assert.assertEquals((long)305419897L, (long)Conversion.binaryToInt((boolean[])src, (int)0, (int)305419897, (int)0, (int)0));
        Assert.assertEquals((long)-2023467399L, (long)Conversion.binaryToInt((boolean[])src, (int)60, (int)305419897, (int)20, (int)12));
    }

    @Test
    public void testBinaryToShort() {
        boolean[] src = new boolean[]{false, false, true, true, true, false, true, true, true, true, true, true, true, false, false, false, true, true, true, true, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, false, true, false, false, true, true, false, false, false, false, true, false, true, false, true, false, false, true, true, false, true, true, true, false, false, false, false, true};
        Assert.assertEquals((long)0L, (long)Conversion.binaryToShort((boolean[])src, (int)0, (short)0, (int)0, (int)0));
        Assert.assertEquals((long)12L, (long)Conversion.binaryToShort((boolean[])src, (int)0, (short)0, (int)0, (int)4));
        Assert.assertEquals((long)8156L, (long)Conversion.binaryToShort((boolean[])src, (int)0, (short)0, (int)0, (int)16));
        Assert.assertEquals((long)-3587L, (long)Conversion.binaryToShort((boolean[])src, (int)4, (short)0, (int)0, (int)16));
        Assert.assertEquals((long)4660L, (long)Conversion.binaryToShort((boolean[])src, (int)0, (short)4660, (int)0, (int)0));
        Assert.assertEquals((long)-30876L, (long)Conversion.binaryToShort((boolean[])src, (int)60, (short)4660, (int)4, (int)12));
    }

    @Test
    public void testBinaryToByte() {
        boolean[] src = new boolean[]{false, false, true, true, true, false, true, true, true, true, true, true, true, false, false, false, true, true, true, true, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, false, true, false, false, true, true, false, false, false, false, true, false, true, false, true, false, false, true, true, false, true, true, true, false, false, false, false, true};
        Assert.assertEquals((long)0L, (long)Conversion.binaryToByte((boolean[])src, (int)0, (byte)0, (int)0, (int)0));
        Assert.assertEquals((long)12L, (long)Conversion.binaryToByte((boolean[])src, (int)0, (byte)0, (int)0, (int)4));
        Assert.assertEquals((long)-36L, (long)Conversion.binaryToByte((boolean[])src, (int)0, (byte)0, (int)0, (int)8));
        Assert.assertEquals((long)-3L, (long)Conversion.binaryToByte((boolean[])src, (int)4, (byte)0, (int)0, (int)8));
        Assert.assertEquals((long)52L, (long)Conversion.binaryToByte((boolean[])src, (int)0, (byte)52, (int)0, (int)0));
        Assert.assertEquals((long)-124L, (long)Conversion.binaryToByte((boolean[])src, (int)68, (byte)52, (int)4, (int)4));
    }

    @Test
    public void testLongToIntArray() {
        Assert.assertArrayEquals((int[])new int[0], (int[])Conversion.longToIntArray((long)0L, (int)0, (int[])new int[0], (int)0, (int)0));
        Assert.assertArrayEquals((int[])new int[0], (int[])Conversion.longToIntArray((long)0L, (int)100, (int[])new int[0], (int)0, (int)0));
        Assert.assertArrayEquals((int[])new int[0], (int[])Conversion.longToIntArray((long)0L, (int)0, (int[])new int[0], (int)100, (int)0));
        Assert.assertArrayEquals((int[])new int[]{-1, -1, -1, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)0, (int[])new int[]{-1, -1, -1, -1}, (int)0, (int)0));
        Assert.assertArrayEquals((int[])new int[]{-1867788817, -1, -1, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)0, (int[])new int[]{-1, -1, -1, -1}, (int)0, (int)1));
        Assert.assertArrayEquals((int[])new int[]{-1867788817, 305419896, -1, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)0, (int[])new int[]{-1, -1, -1, -1}, (int)0, (int)2));
        Assert.assertArrayEquals((int[])new int[]{-1, -1, -1867788817, 305419896}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)0, (int[])new int[]{-1, -1, -1, -1}, (int)2, (int)2));
        Assert.assertArrayEquals((int[])new int[]{-1, -1, -1867788817, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)0, (int[])new int[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((int[])new int[]{-1, -1, -1, -1867788817}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)0, (int[])new int[]{-1, -1, -1, -1}, (int)3, (int)1));
        Assert.assertArrayEquals((int[])new int[]{-1, -1, 1213589239, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)1, (int[])new int[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((int[])new int[]{-1, -1, 606794619, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)2, (int[])new int[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((int[])new int[]{-1, -1, 303397309, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)3, (int[])new int[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((int[])new int[]{-1, -1, -1995784994, -1}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)4, (int[])new int[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((int[])new int[]{152709948}, (int[])Conversion.longToIntArray((long)1311768467294899695L, (int)33, (int[])new int[]{0}, (int)0, (int)1));
    }

    @Test
    public void testLongToShortArray() {
        Assert.assertArrayEquals((short[])new short[0], (short[])Conversion.longToShortArray((long)0L, (int)0, (short[])new short[0], (int)0, (int)0));
        Assert.assertArrayEquals((short[])new short[0], (short[])Conversion.longToShortArray((long)0L, (int)100, (short[])new short[0], (int)0, (int)0));
        Assert.assertArrayEquals((short[])new short[0], (short[])Conversion.longToShortArray((long)0L, (int)0, (short[])new short[0], (int)100, (int)0));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, -1, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)0));
        Assert.assertArrayEquals((short[])new short[]{-12817, -1, -1, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)1));
        Assert.assertArrayEquals((short[])new short[]{-12817, -28501, -1, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)2));
        Assert.assertArrayEquals((short[])new short[]{-12817, -28501, 22136, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)3));
        Assert.assertArrayEquals((short[])new short[]{-12817, -28501, 22136, 4660}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)4));
        Assert.assertArrayEquals((short[])new short[]{-1, -12817, -28501, 22136}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)1, (int)3));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, -12817, -28501}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)2));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, -12817, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, -1, -12817}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)3, (int)1));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, -6409, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)1, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, -3205, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)2, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, 31165, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)3, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, -17186, -1}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)4, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((short[])new short[]{-6409, 18517, 11068, 2330}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)1, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)4));
        Assert.assertArrayEquals((short[])new short[]{11068}, (short[])Conversion.longToShortArray((long)1311768467294899695L, (int)33, (short[])new short[]{0}, (int)0, (int)1));
    }

    @Test
    public void testIntToShortArray() {
        Assert.assertArrayEquals((short[])new short[0], (short[])Conversion.intToShortArray((int)0, (int)0, (short[])new short[0], (int)0, (int)0));
        Assert.assertArrayEquals((short[])new short[0], (short[])Conversion.intToShortArray((int)0, (int)100, (short[])new short[0], (int)0, (int)0));
        Assert.assertArrayEquals((short[])new short[0], (short[])Conversion.intToShortArray((int)0, (int)0, (short[])new short[0], (int)100, (int)0));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, -1, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)0));
        Assert.assertArrayEquals((short[])new short[]{22136, -1, -1, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)1));
        Assert.assertArrayEquals((short[])new short[]{22136, 4660, -1, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)0, (int)2));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, 22136, 4660}, (short[])Conversion.intToShortArray((int)305419896, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)2));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, 22136, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, -1, 22136}, (short[])Conversion.intToShortArray((int)305419896, (int)0, (short[])new short[]{-1, -1, -1, -1}, (int)3, (int)1));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, 11068, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)1, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, 5534, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)2, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, -30001, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)3, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((short[])new short[]{-1, -1, 17767, -1}, (short[])Conversion.intToShortArray((int)305419896, (int)4, (short[])new short[]{-1, -1, -1, -1}, (int)2, (int)1));
        Assert.assertArrayEquals((short[])new short[]{2330}, (short[])Conversion.intToShortArray((int)305419896, (int)17, (short[])new short[]{0}, (int)0, (int)1));
    }

    @Test
    public void testLongToByteArray() {
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.longToByteArray((long)0L, (int)0, (byte[])new byte[0], (int)0, (int)0));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.longToByteArray((long)0L, (int)100, (byte[])new byte[0], (int)0, (int)0));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.longToByteArray((long)0L, (int)0, (byte[])new byte[0], (int)100, (int)0));
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)0));
        Assert.assertArrayEquals((byte[])new byte[]{-17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assert.assertArrayEquals((byte[])new byte[]{-17, -51, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)2));
        Assert.assertArrayEquals((byte[])new byte[]{-17, -51, -85, -112, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)4));
        Assert.assertArrayEquals((byte[])new byte[]{-17, -51, -85, -112, 120, 86, 52, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)7));
        Assert.assertArrayEquals((byte[])new byte[]{-17, -51, -85, -112, 120, 86, 52, 18, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)8));
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)1));
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -51, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)2));
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -51, -85, -112, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)4));
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -51, -85, -112, 120, 86, 52, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)7));
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -51, -85, -112, 120, 86, 52, 18}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)8));
        Assert.assertArrayEquals((byte[])new byte[]{-9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)1, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assert.assertArrayEquals((byte[])new byte[]{123, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)2, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assert.assertArrayEquals((byte[])new byte[]{-1, 0, -1, 111, 94, -123, -60, -77, -94, -111, 0}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)5, (byte[])new byte[]{-1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)8));
        Assert.assertArrayEquals((byte[])new byte[]{-1, 0, -1, 94, -123, -60, -77, -94, -111, 0, -1}, (byte[])Conversion.longToByteArray((long)1311768467294899695L, (int)13, (byte[])new byte[]{-1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)7));
    }

    @Test
    public void testIntToByteArray() {
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.intToByteArray((int)0, (int)0, (byte[])new byte[0], (int)0, (int)0));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.intToByteArray((int)0, (int)100, (byte[])new byte[0], (int)0, (int)0));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.intToByteArray((int)0, (int)0, (byte[])new byte[0], (int)100, (int)0));
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)0));
        Assert.assertArrayEquals((byte[])new byte[]{-17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assert.assertArrayEquals((byte[])new byte[]{-17, -51, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)2));
        Assert.assertArrayEquals((byte[])new byte[]{-17, -51, -85, -112, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)4));
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)1));
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -51, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)2));
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -51, -85, -112, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)4));
        Assert.assertArrayEquals((byte[])new byte[]{-9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)1, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assert.assertArrayEquals((byte[])new byte[]{123, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)2, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assert.assertArrayEquals((byte[])new byte[]{-1, 0, -1, 111, 94, -123, -4, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)5, (byte[])new byte[]{-1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)4));
        Assert.assertArrayEquals((byte[])new byte[]{-1, 0, -1, 94, -123, -4, -1, -1, -1, -1, -1}, (byte[])Conversion.intToByteArray((int)-1867788817, (int)13, (byte[])new byte[]{-1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)3, (int)3));
    }

    @Test
    public void testShortToByteArray() {
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.shortToByteArray((short)0, (int)0, (byte[])new byte[0], (int)0, (int)0));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.shortToByteArray((short)0, (int)100, (byte[])new byte[0], (int)0, (int)0));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])Conversion.shortToByteArray((short)0, (int)0, (byte[])new byte[0], (int)100, (int)0));
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (int)0, (int)0));
        Assert.assertArrayEquals((byte[])new byte[]{-17, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assert.assertArrayEquals((byte[])new byte[]{-17, -51, -1, -1, -1, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (int)0, (int)2));
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -1, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (int)3, (int)1));
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -17, -51, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)0, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (int)3, (int)2));
        Assert.assertArrayEquals((byte[])new byte[]{-9, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)1, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assert.assertArrayEquals((byte[])new byte[]{123, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)2, (byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1}, (int)0, (int)1));
        Assert.assertArrayEquals((byte[])new byte[]{-1, 0, -1, 111, -2, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)5, (byte[])new byte[]{-1, 0, -1, -1, -1, -1, -1}, (int)3, (int)2));
        Assert.assertArrayEquals((byte[])new byte[]{-1, 0, -1, -2, -1, -1, -1}, (byte[])Conversion.shortToByteArray((short)-12817, (int)13, (byte[])new byte[]{-1, 0, -1, -1, -1, -1, -1}, (int)3, (int)1));
    }

    @Test
    public void testLongToHex() {
        Assert.assertEquals((Object)"", (Object)Conversion.longToHex((long)0L, (int)0, (String)"", (int)0, (int)0));
        Assert.assertEquals((Object)"", (Object)Conversion.longToHex((long)0L, (int)100, (String)"", (int)0, (int)0));
        Assert.assertEquals((Object)"", (Object)Conversion.longToHex((long)0L, (int)0, (String)"", (int)100, (int)0));
        Assert.assertEquals((Object)"ffffffffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)0));
        Assert.assertEquals((Object)"3fffffffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899683L, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assert.assertEquals((Object)"feffffffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)2));
        Assert.assertEquals((Object)"fedcffffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)4));
        Assert.assertEquals((Object)"fedcba098765432fffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)15));
        Assert.assertEquals((Object)"fedcba0987654321ffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)16));
        Assert.assertEquals((Object)"fff3ffffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899683L, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)1));
        Assert.assertEquals((Object)"ffffefffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)2));
        Assert.assertEquals((Object)"ffffedcfffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)4));
        Assert.assertEquals((Object)"ffffedcba098765432ffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)15));
        Assert.assertEquals((Object)"ffffedcba0987654321fffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)16));
        Assert.assertEquals((Object)"7fffffffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)1, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assert.assertEquals((Object)"bfffffffffffffffffffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)2, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assert.assertEquals((Object)"fffdb975121fca86420fffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)3, (String)"ffffffffffffffffffffffff", (int)3, (int)16));
        Assert.assertEquals((Object)"fffedcba0987654321ffffff", (Object)Conversion.longToHex((long)1311768467294899695L, (int)4, (String)"ffffffffffffffffffffffff", (int)3, (int)15));
        Assert.assertEquals((Object)"fedcba0987654321", (Object)Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"", (int)0, (int)16));
        try {
            Conversion.longToHex((long)1311768467294899695L, (int)0, (String)"", (int)1, (int)8);
            Assert.fail((String)("Thrown " + StringIndexOutOfBoundsException.class.getName() + " expected"));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testIntToHex() {
        Assert.assertEquals((Object)"", (Object)Conversion.intToHex((int)0, (int)0, (String)"", (int)0, (int)0));
        Assert.assertEquals((Object)"", (Object)Conversion.intToHex((int)0, (int)100, (String)"", (int)0, (int)0));
        Assert.assertEquals((Object)"", (Object)Conversion.intToHex((int)0, (int)0, (String)"", (int)100, (int)0));
        Assert.assertEquals((Object)"ffffffffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)0));
        Assert.assertEquals((Object)"3fffffffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788829, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assert.assertEquals((Object)"feffffffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)2));
        Assert.assertEquals((Object)"fedcffffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)4));
        Assert.assertEquals((Object)"fedcba0fffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)7));
        Assert.assertEquals((Object)"fedcba09ffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)8));
        Assert.assertEquals((Object)"fff3ffffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788829, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)1));
        Assert.assertEquals((Object)"ffffefffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)2));
        Assert.assertEquals((Object)"ffffedcfffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)4));
        Assert.assertEquals((Object)"ffffedcba0ffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)7));
        Assert.assertEquals((Object)"ffffedcba09fffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)8));
        Assert.assertEquals((Object)"7fffffffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)1, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assert.assertEquals((Object)"bfffffffffffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)2, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assert.assertEquals((Object)"fffdb97512ffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)3, (String)"ffffffffffffffffffffffff", (int)3, (int)8));
        Assert.assertEquals((Object)"fffedcba09ffffffffffffff", (Object)Conversion.intToHex((int)-1867788817, (int)4, (String)"ffffffffffffffffffffffff", (int)3, (int)7));
        Assert.assertEquals((Object)"fedcba09", (Object)Conversion.intToHex((int)-1867788817, (int)0, (String)"", (int)0, (int)8));
        try {
            Conversion.intToHex((int)-1867788817, (int)0, (String)"", (int)1, (int)8);
            Assert.fail((String)("Thrown " + StringIndexOutOfBoundsException.class.getName() + " expected"));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testShortToHex() {
        Assert.assertEquals((Object)"", (Object)Conversion.shortToHex((short)0, (int)0, (String)"", (int)0, (int)0));
        Assert.assertEquals((Object)"", (Object)Conversion.shortToHex((short)0, (int)100, (String)"", (int)0, (int)0));
        Assert.assertEquals((Object)"", (Object)Conversion.shortToHex((short)0, (int)0, (String)"", (int)100, (int)0));
        Assert.assertEquals((Object)"ffffffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)0));
        Assert.assertEquals((Object)"3fffffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12829, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assert.assertEquals((Object)"feffffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)2));
        Assert.assertEquals((Object)"fedfffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)3));
        Assert.assertEquals((Object)"fedcffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)0, (String)"ffffffffffffffffffffffff", (int)0, (int)4));
        Assert.assertEquals((Object)"fff3ffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12829, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)1));
        Assert.assertEquals((Object)"ffffefffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)0, (String)"ffffffffffffffffffffffff", (int)3, (int)2));
        Assert.assertEquals((Object)"7fffffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)1, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assert.assertEquals((Object)"bfffffffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)2, (String)"ffffffffffffffffffffffff", (int)0, (int)1));
        Assert.assertEquals((Object)"fffdb9ffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)3, (String)"ffffffffffffffffffffffff", (int)3, (int)4));
        Assert.assertEquals((Object)"fffedcffffffffffffffffff", (Object)Conversion.shortToHex((short)-12817, (int)4, (String)"ffffffffffffffffffffffff", (int)3, (int)3));
        Assert.assertEquals((Object)"fedc", (Object)Conversion.shortToHex((short)-12817, (int)0, (String)"", (int)0, (int)4));
        try {
            Conversion.shortToHex((short)-12817, (int)0, (String)"", (int)1, (int)4);
            Assert.fail((String)("Thrown " + StringIndexOutOfBoundsException.class.getName() + " expected"));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testByteToHex() {
        Assert.assertEquals((Object)"", (Object)Conversion.byteToHex((byte)0, (int)0, (String)"", (int)0, (int)0));
        Assert.assertEquals((Object)"", (Object)Conversion.byteToHex((byte)0, (int)100, (String)"", (int)0, (int)0));
        Assert.assertEquals((Object)"", (Object)Conversion.byteToHex((byte)0, (int)0, (String)"", (int)100, (int)0));
        Assert.assertEquals((Object)"00000", (Object)Conversion.byteToHex((byte)-17, (int)0, (String)"00000", (int)0, (int)0));
        Assert.assertEquals((Object)"f0000", (Object)Conversion.byteToHex((byte)-17, (int)0, (String)"00000", (int)0, (int)1));
        Assert.assertEquals((Object)"fe000", (Object)Conversion.byteToHex((byte)-17, (int)0, (String)"00000", (int)0, (int)2));
        Assert.assertEquals((Object)"000f0", (Object)Conversion.byteToHex((byte)-17, (int)0, (String)"00000", (int)3, (int)1));
        Assert.assertEquals((Object)"000fe", (Object)Conversion.byteToHex((byte)-17, (int)0, (String)"00000", (int)3, (int)2));
        Assert.assertEquals((Object)"70000", (Object)Conversion.byteToHex((byte)-17, (int)1, (String)"00000", (int)0, (int)1));
        Assert.assertEquals((Object)"b0000", (Object)Conversion.byteToHex((byte)-17, (int)2, (String)"00000", (int)0, (int)1));
        Assert.assertEquals((Object)"000df", (Object)Conversion.byteToHex((byte)-17, (int)3, (String)"00000", (int)3, (int)2));
        Assert.assertEquals((Object)"000e0", (Object)Conversion.byteToHex((byte)-17, (int)4, (String)"00000", (int)3, (int)1));
        Assert.assertEquals((Object)"fe", (Object)Conversion.byteToHex((byte)-17, (int)0, (String)"", (int)0, (int)2));
        try {
            Conversion.byteToHex((byte)-17, (int)0, (String)"", (int)1, (int)2);
            Assert.fail((String)("Thrown " + StringIndexOutOfBoundsException.class.getName() + " expected"));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testLongToBinary() {
        ConversionTest.assertBinaryEquals(new boolean[0], Conversion.longToBinary((long)0L, (int)0, (boolean[])new boolean[0], (int)0, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[0], Conversion.longToBinary((long)0L, (int)100, (boolean[])new boolean[0], (int)0, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[0], Conversion.longToBinary((long)0L, (int)0, (boolean[])new boolean[0], (int)100, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[69], Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)0, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)0, (int)1));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)0, (int)2));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)0, (int)3));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, true, true, true, true, false, false, true, true, false, true, false, true, false, false, false, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, false, false, false}, Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)0, (int)63));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, true, true, true, true, false, false, true, true, false, true, false, true, false, false, false, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, false, false, false}, Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)0, (int)64));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)2, (int)1));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, true, true, true, true, false, false, true, true, false, true, false, true, false, false, false, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, false}, Conversion.longToBinary((long)1311768467294899695L, (int)0, (boolean[])new boolean[69], (int)2, (int)64));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, true, true, true, true, false, false, true, true, false, true, false, true, false, false, false, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, false, false, false, false}, Conversion.longToBinary((long)1311768467294899695L, (int)1, (boolean[])new boolean[69], (int)0, (int)63));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, true, true, true, true, false, false, true, true, false, true, false, true, false, false, false, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, false, false, false, false, false}, Conversion.longToBinary((long)1311768467294899695L, (int)2, (boolean[])new boolean[69], (int)0, (int)62));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, false, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, true, true, true, true, false, false, true, true, false, true, false, true, false, false, false, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, false, false}, Conversion.longToBinary((long)1311768467294899695L, (int)2, (boolean[])new boolean[69], (int)3, (int)62));
    }

    @Test
    public void testIntToBinary() {
        ConversionTest.assertBinaryEquals(new boolean[0], Conversion.intToBinary((int)0, (int)0, (boolean[])new boolean[0], (int)0, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[0], Conversion.intToBinary((int)0, (int)100, (boolean[])new boolean[0], (int)0, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[0], Conversion.intToBinary((int)0, (int)0, (boolean[])new boolean[0], (int)100, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[69], Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[69], (int)0, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[37], (int)0, (int)1));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[37], (int)0, (int)2));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[37], (int)0, (int)3));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, false, false, false, false, false, false}, Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[37], (int)0, (int)31));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, false, false}, Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[37], (int)0, (int)32));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[37], (int)2, (int)1));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false}, Conversion.intToBinary((int)-1867788817, (int)0, (boolean[])new boolean[37], (int)2, (int)32));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, false, false, false}, Conversion.intToBinary((int)-1867788817, (int)1, (boolean[])new boolean[37], (int)0, (int)31));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, false, false, false, false}, Conversion.intToBinary((int)-1867788817, (int)2, (boolean[])new boolean[37], (int)0, (int)30));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, false, true, true, false, true, true, true, true, false, true, true, false, false, true, true, true, true, false, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, false, false}, Conversion.intToBinary((int)-1867788817, (int)2, (boolean[])new boolean[37], (int)3, (int)30));
    }

    @Test
    public void testShortToBinary() {
        ConversionTest.assertBinaryEquals(new boolean[0], Conversion.shortToBinary((short)0, (int)0, (boolean[])new boolean[0], (int)0, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[0], Conversion.shortToBinary((short)0, (int)100, (boolean[])new boolean[0], (int)0, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[0], Conversion.shortToBinary((short)0, (int)0, (boolean[])new boolean[0], (int)100, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[69], Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[69], (int)0, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[21], (int)0, (int)1));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[21], (int)0, (int)2));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[21], (int)0, (int)3));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, false, false, false, false, false, false}, Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[21], (int)0, (int)15));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, false, false, false, false, false}, Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[21], (int)0, (int)16));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[21], (int)2, (int)1));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, true, true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, false, false, false}, Conversion.shortToBinary((short)-12817, (int)0, (boolean[])new boolean[21], (int)2, (int)16));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, true, false, true, true, true, true, false, true, true, false, false, true, true, false, false, false, false, false, false}, Conversion.shortToBinary((short)-12817, (int)1, (boolean[])new boolean[21], (int)0, (int)15));
        ConversionTest.assertBinaryEquals(new boolean[]{true, true, false, true, true, true, true, false, true, true, false, false, true, true, false, false, false, false, false, false, false}, Conversion.shortToBinary((short)-12817, (int)2, (boolean[])new boolean[21], (int)0, (int)14));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, false, true, true, false, true, true, true, true, false, true, true, false, false, true, true, false, false, false, false}, Conversion.shortToBinary((short)-12817, (int)2, (boolean[])new boolean[21], (int)3, (int)14));
    }

    @Test
    public void testByteToBinary() {
        ConversionTest.assertBinaryEquals(new boolean[0], Conversion.byteToBinary((byte)0, (int)0, (boolean[])new boolean[0], (int)0, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[0], Conversion.byteToBinary((byte)0, (int)100, (boolean[])new boolean[0], (int)0, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[0], Conversion.byteToBinary((byte)0, (int)0, (boolean[])new boolean[0], (int)100, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[69], Conversion.byteToBinary((byte)-17, (int)0, (boolean[])new boolean[69], (int)0, (int)0));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false}, Conversion.byteToBinary((byte)-107, (int)0, (boolean[])new boolean[13], (int)0, (int)1));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false}, Conversion.byteToBinary((byte)-107, (int)0, (boolean[])new boolean[13], (int)0, (int)2));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, true, false, false, false, false, false, false, false, false, false, false}, Conversion.byteToBinary((byte)-107, (int)0, (boolean[])new boolean[13], (int)0, (int)3));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, true, false, true, false, false, false, false, false, false, false, false}, Conversion.byteToBinary((byte)-107, (int)0, (boolean[])new boolean[13], (int)0, (int)7));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, true, false, true, false, false, true, false, false, false, false, false}, Conversion.byteToBinary((byte)-107, (int)0, (boolean[])new boolean[13], (int)0, (int)8));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, true, false, false, false, false, false, false, false, false, false, false}, Conversion.byteToBinary((byte)-107, (int)0, (boolean[])new boolean[13], (int)2, (int)1));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, true, false, true, false, true, false, false, true, false, false, false}, Conversion.byteToBinary((byte)-107, (int)0, (boolean[])new boolean[13], (int)2, (int)8));
        ConversionTest.assertBinaryEquals(new boolean[]{false, true, false, true, false, false, true, false, false, false, false, false, false}, Conversion.byteToBinary((byte)-107, (int)1, (boolean[])new boolean[13], (int)0, (int)7));
        ConversionTest.assertBinaryEquals(new boolean[]{true, false, true, false, false, true, false, false, false, false, false, false, false}, Conversion.byteToBinary((byte)-107, (int)2, (boolean[])new boolean[13], (int)0, (int)6));
        ConversionTest.assertBinaryEquals(new boolean[]{false, false, false, true, false, true, false, false, true, false, false, false, false}, Conversion.byteToBinary((byte)-107, (int)2, (boolean[])new boolean[13], (int)3, (int)6));
    }

    @Test
    public void testUuidToByteArray() {
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])Conversion.uuidToByteArray((UUID)new UUID(-1L, -1L), (byte[])new byte[16], (int)0, (int)16));
        Assert.assertArrayEquals((byte[])new byte[]{-120, -103, -86, -69, -52, -35, -18, -1, 0, 17, 34, 51, 68, 85, 102, 119}, (byte[])Conversion.uuidToByteArray((UUID)new UUID(-4822678189205112L, 8603657889541918976L), (byte[])new byte[16], (int)0, (int)16));
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, -120, -103, -86, -69, -52, -35, -18, -1, 0, 0, 0, 0}, (byte[])Conversion.uuidToByteArray((UUID)new UUID(-4822678189205112L, 8603657889541918976L), (byte[])new byte[16], (int)4, (int)8));
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, -120, -103, -86, -69, -52, -35, -18, -1, 0, 17, 34, 51, 0, 0}, (byte[])Conversion.uuidToByteArray((UUID)new UUID(-4822678189205112L, 8603657889541918976L), (byte[])new byte[16], (int)2, (int)12));
    }

    @Test
    public void testByteArrayToUuid() {
        Assert.assertEquals((Object)new UUID(-1L, -1L), (Object)Conversion.byteArrayToUuid((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)0));
        Assert.assertEquals((Object)new UUID(-4822678189205112L, 8603657889541918976L), (Object)Conversion.byteArrayToUuid((byte[])new byte[]{-120, -103, -86, -69, -52, -35, -18, -1, 0, 17, 34, 51, 68, 85, 102, 119}, (int)0));
        Assert.assertEquals((Object)new UUID(-4822678189205112L, 8603657889541918976L), (Object)Conversion.byteArrayToUuid((byte[])new byte[]{0, 0, -120, -103, -86, -69, -52, -35, -18, -1, 0, 17, 34, 51, 68, 85, 102, 119}, (int)2));
    }
}

