/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import org.apache.commons.lang3.builder.Diff;
import org.junit.Assert;
import org.junit.Test;

public class DiffTest {
    private static final String FIELD_NAME = "field";
    private static final Diff<Boolean> booleanDiff = new BooleanDiff("field");

    @Test(expected=UnsupportedOperationException.class)
    public void testCannotModify() {
        booleanDiff.setValue((Object)Boolean.FALSE);
    }

    @Test
    public void testGetFieldName() {
        Assert.assertEquals((Object)FIELD_NAME, (Object)booleanDiff.getFieldName());
    }

    @Test
    public void testGetType() {
        Assert.assertEquals(Boolean.class, (Object)booleanDiff.getType());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)String.format("[%s: %s, %s]", FIELD_NAME, booleanDiff.getLeft(), booleanDiff.getRight()), (Object)booleanDiff.toString());
    }

    private static class BooleanDiff
    extends Diff<Boolean> {
        private static final long serialVersionUID = 1L;

        protected BooleanDiff(String fieldName) {
            super(fieldName);
        }

        public Boolean getLeft() {
            return Boolean.TRUE;
        }

        public Boolean getRight() {
            return Boolean.FALSE;
        }
    }
}

