/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.junit.Assert;
import org.junit.Test;

public class BackgroundInitializerTest {
    private void checkInitialize(BackgroundInitializerTestImpl init) {
        try {
            Integer result = (Integer)init.get();
            Assert.assertEquals((String)"Wrong result", (long)1L, (long)result.intValue());
            Assert.assertEquals((String)"Wrong number of invocations", (long)1L, (long)init.initializeCalls);
            Assert.assertNotNull((String)"No future", (Object)init.getFuture());
        }
        catch (ConcurrentException cex) {
            Assert.fail((String)("Unexpected exception: " + (Object)((Object)cex)));
        }
    }

    @Test
    public void testInitialize() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        this.checkInitialize(init);
    }

    @Test
    public void testGetActiveExecutorBeforeStart() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        Assert.assertNull((String)"Got an executor", (Object)init.getActiveExecutor());
    }

    @Test
    public void testGetActiveExecutorExternal() throws InterruptedException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl(exec);
            init.start();
            Assert.assertSame((String)"Wrong executor", (Object)exec, (Object)init.getActiveExecutor());
            this.checkInitialize(init);
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testGetActiveExecutorTemp() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        Assert.assertNotNull((String)"No active executor", (Object)init.getActiveExecutor());
        this.checkInitialize(init);
    }

    @Test
    public void testInitializeTempExecutor() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        Assert.assertTrue((String)"Wrong result of start()", (boolean)init.start());
        this.checkInitialize(init);
        Assert.assertTrue((String)"Executor not shutdown", (boolean)init.getActiveExecutor().isShutdown());
    }

    @Test
    public void testSetExternalExecutor() {
        ExecutorService exec = Executors.newCachedThreadPool();
        try {
            BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
            init.setExternalExecutor(exec);
            Assert.assertEquals((String)"Wrong executor service", (Object)exec, (Object)init.getExternalExecutor());
            Assert.assertTrue((String)"Wrong result of start()", (boolean)init.start());
            Assert.assertSame((String)"Wrong active executor", (Object)exec, (Object)init.getActiveExecutor());
            this.checkInitialize(init);
            Assert.assertFalse((String)"Executor was shutdown", (boolean)exec.isShutdown());
        }
        finally {
            exec.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetExternalExecutorAfterStart() throws ConcurrentException, InterruptedException {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            init.setExternalExecutor(exec);
            Assert.fail((String)"Could set executor after start()!");
        }
        catch (IllegalStateException istex) {
            init.get();
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testStartMultipleTimes() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        Assert.assertTrue((String)"Wrong result for start()", (boolean)init.start());
        for (int i = 0; i < 10; ++i) {
            Assert.assertFalse((String)"Could start again", (boolean)init.start());
        }
        this.checkInitialize(init);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetBeforeStart() throws ConcurrentException {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.get();
    }

    @Test
    public void testGetRuntimeException() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        RuntimeException rex = new RuntimeException();
        init.ex = rex;
        init.start();
        try {
            init.get();
            Assert.fail((String)"Exception not thrown!");
        }
        catch (Exception ex) {
            Assert.assertEquals((String)"Runtime exception not thrown", (Object)rex, (Object)ex);
        }
    }

    @Test
    public void testGetCheckedException() {
        Exception ex;
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.ex = ex = new Exception();
        init.start();
        try {
            init.get();
            Assert.fail((String)"Exception not thrown!");
        }
        catch (ConcurrentException cex) {
            Assert.assertEquals((String)"Exception not thrown", (Object)ex, (Object)cex.getCause());
        }
    }

    @Test
    public void testGetInterruptedException() throws InterruptedException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        final BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl(exec);
        final CountDownLatch latch1 = new CountDownLatch(1);
        init.shouldSleep = true;
        init.start();
        final AtomicReference iex = new AtomicReference();
        Thread getThread = new Thread(){

            @Override
            public void run() {
                try {
                    init.get();
                }
                catch (ConcurrentException cex) {
                    if (cex.getCause() instanceof InterruptedException) {
                        iex.set((InterruptedException)cex.getCause());
                    }
                }
                finally {
                    Assert.assertTrue((String)"Thread not interrupted", (boolean)this.isInterrupted());
                    latch1.countDown();
                }
            }
        };
        getThread.start();
        getThread.interrupt();
        latch1.await();
        exec.shutdownNow();
        exec.awaitTermination(1L, TimeUnit.SECONDS);
        Assert.assertNotNull((String)"No interrupted exception", iex.get());
    }

    @Test
    public void testIsStartedFalse() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        Assert.assertFalse((String)"Already started", (boolean)init.isStarted());
    }

    @Test
    public void testIsStartedTrue() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        Assert.assertTrue((String)"Not started", (boolean)init.isStarted());
    }

    @Test
    public void testIsStartedAfterGet() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        this.checkInitialize(init);
        Assert.assertTrue((String)"Not started", (boolean)init.isStarted());
    }

    private static class BackgroundInitializerTestImpl
    extends BackgroundInitializer<Integer> {
        Exception ex;
        boolean shouldSleep;
        volatile int initializeCalls;

        public BackgroundInitializerTestImpl() {
        }

        public BackgroundInitializerTestImpl(ExecutorService exec) {
            super(exec);
        }

        protected Integer initialize() throws Exception {
            if (this.ex != null) {
                throw this.ex;
            }
            if (this.shouldSleep) {
                Thread.sleep(60000L);
            }
            return ++this.initializeCalls;
        }
    }
}

