/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.test.NotVisibleExceptionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExceptionUtilsTest {
    private NestableException nested;
    private Throwable withCause;
    private Throwable withoutCause;
    private Throwable jdkNoCause;
    private ExceptionWithCause cyclicCause;
    private Throwable notVisibleException;

    @Before
    public void setUp() {
        this.withoutCause = this.createExceptionWithoutCause();
        this.nested = new NestableException(this.withoutCause);
        this.withCause = new ExceptionWithCause(this.nested);
        this.jdkNoCause = new NullPointerException();
        ExceptionWithCause a = new ExceptionWithCause(null);
        ExceptionWithCause b = new ExceptionWithCause(a);
        a.setCause(b);
        this.cyclicCause = new ExceptionWithCause(a);
        this.notVisibleException = NotVisibleExceptionFactory.createException(this.withoutCause);
    }

    @After
    public void tearDown() throws Exception {
        this.withoutCause = null;
        this.nested = null;
        this.withCause = null;
        this.jdkNoCause = null;
        this.cyclicCause = null;
        this.notVisibleException = null;
    }

    private Throwable createExceptionWithoutCause() {
        try {
            throw new ExceptionWithoutCause();
        }
        catch (Throwable t) {
            return t;
        }
    }

    private Throwable createExceptionWithCause() {
        try {
            try {
                throw new ExceptionWithCause(this.createExceptionWithoutCause());
            }
            catch (Throwable t) {
                throw new ExceptionWithCause(t);
            }
        }
        catch (Throwable t) {
            return t;
        }
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new ExceptionUtils());
        Constructor<?>[] cons = ExceptionUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(ExceptionUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(ExceptionUtils.class.getModifiers()));
    }

    @Test
    public void testGetCause_Throwable() {
        Assert.assertSame(null, (Object)ExceptionUtils.getCause(null));
        Assert.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause));
        Assert.assertSame((Object)this.withoutCause, (Object)ExceptionUtils.getCause((Throwable)this.nested));
        Assert.assertSame((Object)this.nested, (Object)ExceptionUtils.getCause((Throwable)this.withCause));
        Assert.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.jdkNoCause));
        Assert.assertSame((Object)this.cyclicCause.getCause(), (Object)ExceptionUtils.getCause((Throwable)this.cyclicCause));
        Assert.assertSame((Object)((ExceptionWithCause)this.cyclicCause.getCause()).getCause(), (Object)ExceptionUtils.getCause((Throwable)this.cyclicCause.getCause()));
        Assert.assertSame((Object)this.cyclicCause.getCause(), (Object)ExceptionUtils.getCause((Throwable)((ExceptionWithCause)this.cyclicCause.getCause()).getCause()));
        Assert.assertSame((Object)this.withoutCause, (Object)ExceptionUtils.getCause((Throwable)this.notVisibleException));
    }

    @Test
    public void testGetCause_ThrowableArray() {
        Assert.assertSame(null, (Object)ExceptionUtils.getCause(null, null));
        Assert.assertSame(null, (Object)ExceptionUtils.getCause(null, (String[])new String[0]));
        Assert.assertSame((Object)this.nested, (Object)ExceptionUtils.getCause((Throwable)this.withCause, null));
        Assert.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withCause, (String[])new String[0]));
        Assert.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withCause, (String[])new String[]{null}));
        Assert.assertSame((Object)this.nested, (Object)ExceptionUtils.getCause((Throwable)this.withCause, (String[])new String[]{"getCause"}));
        Assert.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, null));
        Assert.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, (String[])new String[0]));
        Assert.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, (String[])new String[]{null}));
        Assert.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, (String[])new String[]{"getCause"}));
        Assert.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, (String[])new String[]{"getTargetException"}));
    }

    @Test
    public void testGetRootCause_Throwable() {
        Assert.assertSame(null, (Object)ExceptionUtils.getRootCause(null));
        Assert.assertSame(null, (Object)ExceptionUtils.getRootCause((Throwable)this.withoutCause));
        Assert.assertSame((Object)this.withoutCause, (Object)ExceptionUtils.getRootCause((Throwable)this.nested));
        Assert.assertSame((Object)this.withoutCause, (Object)ExceptionUtils.getRootCause((Throwable)this.withCause));
        Assert.assertSame(null, (Object)ExceptionUtils.getRootCause((Throwable)this.jdkNoCause));
        Assert.assertSame((Object)((ExceptionWithCause)this.cyclicCause.getCause()).getCause(), (Object)ExceptionUtils.getRootCause((Throwable)this.cyclicCause));
    }

    @Test
    public void testGetThrowableCount_Throwable() {
        Assert.assertEquals((long)0L, (long)ExceptionUtils.getThrowableCount(null));
        Assert.assertEquals((long)1L, (long)ExceptionUtils.getThrowableCount((Throwable)this.withoutCause));
        Assert.assertEquals((long)2L, (long)ExceptionUtils.getThrowableCount((Throwable)this.nested));
        Assert.assertEquals((long)3L, (long)ExceptionUtils.getThrowableCount((Throwable)this.withCause));
        Assert.assertEquals((long)1L, (long)ExceptionUtils.getThrowableCount((Throwable)this.jdkNoCause));
        Assert.assertEquals((long)3L, (long)ExceptionUtils.getThrowableCount((Throwable)this.cyclicCause));
    }

    @Test
    public void testGetThrowables_Throwable_null() {
        Assert.assertEquals((long)0L, (long)ExceptionUtils.getThrowables(null).length);
    }

    @Test
    public void testGetThrowables_Throwable_withoutCause() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.withoutCause);
        Assert.assertEquals((long)1L, (long)throwables.length);
        Assert.assertSame((Object)this.withoutCause, (Object)throwables[0]);
    }

    @Test
    public void testGetThrowables_Throwable_nested() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.nested);
        Assert.assertEquals((long)2L, (long)throwables.length);
        Assert.assertSame((Object)this.nested, (Object)throwables[0]);
        Assert.assertSame((Object)this.withoutCause, (Object)throwables[1]);
    }

    @Test
    public void testGetThrowables_Throwable_withCause() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.withCause);
        Assert.assertEquals((long)3L, (long)throwables.length);
        Assert.assertSame((Object)this.withCause, (Object)throwables[0]);
        Assert.assertSame((Object)this.nested, (Object)throwables[1]);
        Assert.assertSame((Object)this.withoutCause, (Object)throwables[2]);
    }

    @Test
    public void testGetThrowables_Throwable_jdkNoCause() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.jdkNoCause);
        Assert.assertEquals((long)1L, (long)throwables.length);
        Assert.assertSame((Object)this.jdkNoCause, (Object)throwables[0]);
    }

    @Test
    public void testGetThrowables_Throwable_recursiveCause() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.cyclicCause);
        Assert.assertEquals((long)3L, (long)throwables.length);
        Assert.assertSame((Object)this.cyclicCause, (Object)throwables[0]);
        Assert.assertSame((Object)this.cyclicCause.getCause(), (Object)throwables[1]);
        Assert.assertSame((Object)((ExceptionWithCause)this.cyclicCause.getCause()).getCause(), (Object)throwables[2]);
    }

    @Test
    public void testGetThrowableList_Throwable_null() {
        List throwables = ExceptionUtils.getThrowableList(null);
        Assert.assertEquals((long)0L, (long)throwables.size());
    }

    @Test
    public void testGetThrowableList_Throwable_withoutCause() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.withoutCause);
        Assert.assertEquals((long)1L, (long)throwables.size());
        Assert.assertSame((Object)this.withoutCause, throwables.get(0));
    }

    @Test
    public void testGetThrowableList_Throwable_nested() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.nested);
        Assert.assertEquals((long)2L, (long)throwables.size());
        Assert.assertSame((Object)this.nested, throwables.get(0));
        Assert.assertSame((Object)this.withoutCause, throwables.get(1));
    }

    @Test
    public void testGetThrowableList_Throwable_withCause() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.withCause);
        Assert.assertEquals((long)3L, (long)throwables.size());
        Assert.assertSame((Object)this.withCause, throwables.get(0));
        Assert.assertSame((Object)this.nested, throwables.get(1));
        Assert.assertSame((Object)this.withoutCause, throwables.get(2));
    }

    @Test
    public void testGetThrowableList_Throwable_jdkNoCause() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.jdkNoCause);
        Assert.assertEquals((long)1L, (long)throwables.size());
        Assert.assertSame((Object)this.jdkNoCause, throwables.get(0));
    }

    @Test
    public void testGetThrowableList_Throwable_recursiveCause() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.cyclicCause);
        Assert.assertEquals((long)3L, (long)throwables.size());
        Assert.assertSame((Object)this.cyclicCause, throwables.get(0));
        Assert.assertSame((Object)this.cyclicCause.getCause(), throwables.get(1));
        Assert.assertSame((Object)((ExceptionWithCause)this.cyclicCause.getCause()).getCause(), throwables.get(2));
    }

    @Test
    public void testIndexOf_ThrowableClass() {
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable(null, null));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable(null, NestableException.class));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, null));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, ExceptionWithCause.class));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, NestableException.class));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, ExceptionWithoutCause.class));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.nested, null));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.nested, ExceptionWithCause.class));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.nested, NestableException.class));
        Assert.assertEquals((long)1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.nested, ExceptionWithoutCause.class));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, null));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class));
        Assert.assertEquals((long)1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, NestableException.class));
        Assert.assertEquals((long)2L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithoutCause.class));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, Exception.class));
    }

    @Test
    public void testIndexOf_ThrowableClassInt() {
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable(null, null, (int)0));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable(null, NestableException.class, (int)0));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, null));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, ExceptionWithCause.class, (int)0));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, NestableException.class, (int)0));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, ExceptionWithoutCause.class, (int)0));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.nested, null, (int)0));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.nested, ExceptionWithCause.class, (int)0));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.nested, NestableException.class, (int)0));
        Assert.assertEquals((long)1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.nested, ExceptionWithoutCause.class, (int)0));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, null));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        Assert.assertEquals((long)1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, NestableException.class, (int)0));
        Assert.assertEquals((long)2L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithoutCause.class, (int)0));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)-1));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)1));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)9));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, Exception.class, (int)0));
    }

    @Test
    public void testIndexOfType_ThrowableClass() {
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType(null, null));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType(null, NestableException.class));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType((Throwable)this.withoutCause, null));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType((Throwable)this.withoutCause, ExceptionWithCause.class));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType((Throwable)this.withoutCause, NestableException.class));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfType((Throwable)this.withoutCause, ExceptionWithoutCause.class));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType((Throwable)this.nested, null));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType((Throwable)this.nested, ExceptionWithCause.class));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfType((Throwable)this.nested, NestableException.class));
        Assert.assertEquals((long)1L, (long)ExceptionUtils.indexOfType((Throwable)this.nested, ExceptionWithoutCause.class));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType((Throwable)this.withCause, null));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class));
        Assert.assertEquals((long)1L, (long)ExceptionUtils.indexOfType((Throwable)this.withCause, NestableException.class));
        Assert.assertEquals((long)2L, (long)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithoutCause.class));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfType((Throwable)this.withCause, Exception.class));
    }

    @Test
    public void testIndexOfType_ThrowableClassInt() {
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType(null, null, (int)0));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType(null, NestableException.class, (int)0));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType((Throwable)this.withoutCause, null));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType((Throwable)this.withoutCause, ExceptionWithCause.class, (int)0));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType((Throwable)this.withoutCause, NestableException.class, (int)0));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfType((Throwable)this.withoutCause, ExceptionWithoutCause.class, (int)0));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType((Throwable)this.nested, null, (int)0));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType((Throwable)this.nested, ExceptionWithCause.class, (int)0));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfType((Throwable)this.nested, NestableException.class, (int)0));
        Assert.assertEquals((long)1L, (long)ExceptionUtils.indexOfType((Throwable)this.nested, ExceptionWithoutCause.class, (int)0));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType((Throwable)this.withCause, null));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        Assert.assertEquals((long)1L, (long)ExceptionUtils.indexOfType((Throwable)this.withCause, NestableException.class, (int)0));
        Assert.assertEquals((long)2L, (long)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithoutCause.class, (int)0));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)-1));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)1));
        Assert.assertEquals((long)-1L, (long)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)9));
        Assert.assertEquals((long)0L, (long)ExceptionUtils.indexOfType((Throwable)this.withCause, Exception.class, (int)0));
    }

    @Test
    public void testPrintRootCauseStackTrace_Throwable() throws Exception {
        ExceptionUtils.printRootCauseStackTrace(null);
    }

    @Test
    public void testPrintRootCauseStackTrace_ThrowableStream() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        ExceptionUtils.printRootCauseStackTrace(null, (PrintStream)null);
        ExceptionUtils.printRootCauseStackTrace(null, (PrintStream)new PrintStream(out));
        Assert.assertEquals((long)0L, (long)out.toString().length());
        out = new ByteArrayOutputStream(1024);
        try {
            ExceptionUtils.printRootCauseStackTrace((Throwable)this.withCause, (PrintStream)null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        out = new ByteArrayOutputStream(1024);
        Throwable cause = this.createExceptionWithCause();
        ExceptionUtils.printRootCauseStackTrace((Throwable)cause, (PrintStream)new PrintStream(out));
        String stackTrace = out.toString();
        Assert.assertTrue((stackTrace.indexOf(" [wrapped] ") != -1 ? 1 : 0) != 0);
        out = new ByteArrayOutputStream(1024);
        ExceptionUtils.printRootCauseStackTrace((Throwable)this.withoutCause, (PrintStream)new PrintStream(out));
        stackTrace = out.toString();
        Assert.assertTrue((stackTrace.indexOf(" [wrapped] ") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testPrintRootCauseStackTrace_ThrowableWriter() throws Exception {
        StringWriter writer = new StringWriter(1024);
        ExceptionUtils.printRootCauseStackTrace(null, (PrintWriter)null);
        ExceptionUtils.printRootCauseStackTrace(null, (PrintWriter)new PrintWriter(writer));
        Assert.assertEquals((long)0L, (long)writer.getBuffer().length());
        writer = new StringWriter(1024);
        try {
            ExceptionUtils.printRootCauseStackTrace((Throwable)this.withCause, (PrintWriter)null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        writer = new StringWriter(1024);
        Throwable cause = this.createExceptionWithCause();
        ExceptionUtils.printRootCauseStackTrace((Throwable)cause, (PrintWriter)new PrintWriter(writer));
        String stackTrace = writer.toString();
        Assert.assertTrue((stackTrace.indexOf(" [wrapped] ") != -1 ? 1 : 0) != 0);
        writer = new StringWriter(1024);
        ExceptionUtils.printRootCauseStackTrace((Throwable)this.withoutCause, (PrintWriter)new PrintWriter(writer));
        stackTrace = writer.toString();
        Assert.assertTrue((stackTrace.indexOf(" [wrapped] ") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetRootCauseStackTrace_Throwable() throws Exception {
        Assert.assertEquals((long)0L, (long)ExceptionUtils.getRootCauseStackTrace(null).length);
        Throwable cause = this.createExceptionWithCause();
        String[] stackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)cause);
        boolean match = false;
        for (String element : stackTrace) {
            if (!element.startsWith(" [wrapped] ")) continue;
            match = true;
            break;
        }
        Assert.assertTrue((boolean)match);
        stackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)this.withoutCause);
        match = false;
        for (String element : stackTrace) {
            if (!element.startsWith(" [wrapped] ")) continue;
            match = true;
            break;
        }
        Assert.assertFalse((boolean)match);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveCommonFrames_ListList() throws Exception {
        ExceptionUtils.removeCommonFrames(null, null);
    }

    @Test
    public void test_getMessage_Throwable() {
        Exception th = null;
        Assert.assertEquals((Object)"", (Object)ExceptionUtils.getMessage(th));
        th = new IllegalArgumentException("Base");
        Assert.assertEquals((Object)"IllegalArgumentException: Base", (Object)ExceptionUtils.getMessage((Throwable)th));
        th = new ExceptionWithCause("Wrapper", th);
        Assert.assertEquals((Object)"ExceptionUtilsTest.ExceptionWithCause: Wrapper", (Object)ExceptionUtils.getMessage((Throwable)th));
    }

    @Test
    public void test_getRootCauseMessage_Throwable() {
        Exception th = null;
        Assert.assertEquals((Object)"", (Object)ExceptionUtils.getRootCauseMessage(th));
        th = new IllegalArgumentException("Base");
        Assert.assertEquals((Object)"IllegalArgumentException: Base", (Object)ExceptionUtils.getRootCauseMessage((Throwable)th));
        th = new ExceptionWithCause("Wrapper", th);
        Assert.assertEquals((Object)"IllegalArgumentException: Base", (Object)ExceptionUtils.getRootCauseMessage((Throwable)th));
    }

    @Test
    public void testThrow() {
        InterruptedException expected = new InterruptedException();
        try {
            ExceptionUtils.rethrow((Throwable)expected);
            Assert.fail((String)"Exception not thrown");
        }
        catch (Exception actual) {
            Assert.assertSame((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testCatchTechniques() {
        try {
            ExceptionUtilsTest.throwsCheckedException();
            Assert.fail((String)"Exception not thrown");
        }
        catch (Exception ioe) {
            Assert.assertTrue((boolean)(ioe instanceof IOException));
            Assert.assertEquals((long)1L, (long)ExceptionUtils.getThrowableCount((Throwable)ioe));
        }
        try {
            ExceptionUtilsTest.redeclareCheckedException();
            Assert.fail((String)"Exception not thrown");
        }
        catch (IOException ioe) {
            Assert.assertEquals((long)1L, (long)ExceptionUtils.getThrowableCount((Throwable)ioe));
        }
    }

    private static int redeclareCheckedException() throws IOException {
        return ExceptionUtilsTest.throwsCheckedException();
    }

    private static int throwsCheckedException() {
        try {
            throw new IOException();
        }
        catch (Exception e) {
            return (Integer)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    @Test
    public void testWrapAndUnwrapError() {
        try {
            ExceptionUtils.wrapAndThrow((Throwable)new OutOfMemoryError());
            Assert.fail((String)"Error not thrown");
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)t, Error.class));
        }
    }

    @Test
    public void testWrapAndUnwrapRuntimeException() {
        try {
            ExceptionUtils.wrapAndThrow((Throwable)new IllegalArgumentException());
            Assert.fail((String)"RuntimeException not thrown");
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)t, RuntimeException.class));
        }
    }

    @Test
    public void testWrapAndUnwrapCheckedException() {
        try {
            ExceptionUtils.wrapAndThrow((Throwable)new IOException());
            Assert.fail((String)"Checked Exception not thrown");
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)t, IOException.class));
        }
    }

    @Test
    public void testWrapAndUnwrapThrowable() {
        try {
            ExceptionUtils.wrapAndThrow((Throwable)new TestThrowable());
            Assert.fail((String)"Checked Exception not thrown");
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)t, TestThrowable.class));
        }
    }

    public static class TestThrowable
    extends Throwable {
        private static final long serialVersionUID = 1L;
    }

    private static class NestableException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NestableException() {
        }

        public NestableException(Throwable t) {
            super(t);
        }
    }

    private static class ExceptionWithoutCause
    extends Exception {
        private static final long serialVersionUID = 1L;

        private ExceptionWithoutCause() {
        }

        public void getTargetException() {
        }
    }

    private static class ExceptionWithCause
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Throwable cause;

        public ExceptionWithCause(String str, Throwable cause) {
            super(str);
            this.setCause(cause);
        }

        public ExceptionWithCause(Throwable cause) {
            this.setCause(cause);
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }

        public void setCause(Throwable cause) {
            this.cause = cause;
        }
    }
}

