/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.MutableShort;
import org.junit.Assert;
import org.junit.Test;

public class MutableShortTest {
    @Test
    public void testConstructors() {
        Assert.assertEquals((long)0L, (long)new MutableShort().shortValue());
        Assert.assertEquals((long)1L, (long)new MutableShort(1).shortValue());
        Assert.assertEquals((long)2L, (long)new MutableShort((Number)2).shortValue());
        Assert.assertEquals((long)3L, (long)new MutableShort((Number)new MutableShort(3)).shortValue());
        Assert.assertEquals((long)2L, (long)new MutableShort("2").shortValue());
        try {
            new MutableShort((Number)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetSet() {
        MutableShort mutNum = new MutableShort(0);
        Assert.assertEquals((long)0L, (long)new MutableShort().shortValue());
        Assert.assertEquals((Object)0, (Object)new MutableShort().getValue());
        mutNum.setValue((short)1);
        Assert.assertEquals((long)1L, (long)mutNum.shortValue());
        Assert.assertEquals((Object)1, (Object)mutNum.getValue());
        mutNum.setValue((Number)2);
        Assert.assertEquals((long)2L, (long)mutNum.shortValue());
        Assert.assertEquals((Object)2, (Object)mutNum.getValue());
        mutNum.setValue((Number)new MutableShort(3));
        Assert.assertEquals((long)3L, (long)mutNum.shortValue());
        Assert.assertEquals((Object)3, (Object)mutNum.getValue());
        try {
            mutNum.setValue(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testEquals() {
        MutableShort mutNumA = new MutableShort(0);
        MutableShort mutNumB = new MutableShort(0);
        MutableShort mutNumC = new MutableShort(1);
        Assert.assertTrue((boolean)mutNumA.equals((Object)mutNumA));
        Assert.assertTrue((boolean)mutNumA.equals((Object)mutNumB));
        Assert.assertTrue((boolean)mutNumB.equals((Object)mutNumA));
        Assert.assertTrue((boolean)mutNumB.equals((Object)mutNumB));
        Assert.assertFalse((boolean)mutNumA.equals((Object)mutNumC));
        Assert.assertFalse((boolean)mutNumB.equals((Object)mutNumC));
        Assert.assertTrue((boolean)mutNumC.equals((Object)mutNumC));
        Assert.assertFalse((boolean)mutNumA.equals(null));
        Assert.assertFalse((boolean)mutNumA.equals((Object)0));
        Assert.assertFalse((boolean)mutNumA.equals((Object)"0"));
    }

    @Test
    public void testHashCode() {
        MutableShort mutNumA = new MutableShort(0);
        MutableShort mutNumB = new MutableShort(0);
        MutableShort mutNumC = new MutableShort(1);
        Assert.assertTrue((mutNumA.hashCode() == mutNumA.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mutNumA.hashCode() == mutNumB.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((mutNumA.hashCode() == mutNumC.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mutNumA.hashCode() == Short.valueOf((short)0).hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testCompareTo() {
        MutableShort mutNum = new MutableShort(0);
        Assert.assertEquals((long)0L, (long)mutNum.compareTo(new MutableShort(0)));
        Assert.assertEquals((long)1L, (long)mutNum.compareTo(new MutableShort(-1)));
        Assert.assertEquals((long)-1L, (long)mutNum.compareTo(new MutableShort(1)));
        try {
            mutNum.compareTo(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testPrimitiveValues() {
        MutableShort mutNum = new MutableShort(1);
        Assert.assertEquals((float)1.0f, (float)mutNum.floatValue(), (float)0.0f);
        Assert.assertEquals((double)1.0, (double)mutNum.doubleValue(), (double)0.0);
        Assert.assertEquals((long)1L, (long)mutNum.byteValue());
        Assert.assertEquals((long)1L, (long)mutNum.shortValue());
        Assert.assertEquals((long)1L, (long)mutNum.intValue());
        Assert.assertEquals((long)1L, (long)mutNum.longValue());
    }

    @Test
    public void testToShort() {
        Assert.assertEquals((Object)0, (Object)new MutableShort(0).toShort());
        Assert.assertEquals((Object)123, (Object)new MutableShort(123).toShort());
    }

    @Test
    public void testIncrement() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.increment();
        Assert.assertEquals((long)2L, (long)mutNum.intValue());
        Assert.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testIncrementAndGet() {
        MutableShort mutNum = new MutableShort(1);
        short result = mutNum.incrementAndGet();
        Assert.assertEquals((long)2L, (long)result);
        Assert.assertEquals((long)2L, (long)mutNum.intValue());
        Assert.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testGetAndIncrement() {
        MutableShort mutNum = new MutableShort(1);
        short result = mutNum.getAndIncrement();
        Assert.assertEquals((long)1L, (long)result);
        Assert.assertEquals((long)2L, (long)mutNum.intValue());
        Assert.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testDecrement() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.decrement();
        Assert.assertEquals((long)0L, (long)mutNum.intValue());
        Assert.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testDecrementAndGet() {
        MutableShort mutNum = new MutableShort(1);
        short result = mutNum.decrementAndGet();
        Assert.assertEquals((long)0L, (long)result);
        Assert.assertEquals((long)0L, (long)mutNum.intValue());
        Assert.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testGetAndDecrement() {
        MutableShort mutNum = new MutableShort(1);
        short result = mutNum.getAndDecrement();
        Assert.assertEquals((long)1L, (long)result);
        Assert.assertEquals((long)0L, (long)mutNum.intValue());
        Assert.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testAddValuePrimitive() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.add((short)1);
        Assert.assertEquals((long)2L, (long)mutNum.shortValue());
    }

    @Test
    public void testAddValueObject() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.add((Number)1);
        Assert.assertEquals((long)2L, (long)mutNum.shortValue());
    }

    @Test
    public void testGetAndAddValuePrimitive() {
        MutableShort mutableShort = new MutableShort(0);
        short result = mutableShort.getAndAdd((short)1);
        Assert.assertEquals((long)0L, (long)result);
        Assert.assertEquals((long)1L, (long)mutableShort.shortValue());
    }

    @Test
    public void testGetAndAddValueObject() {
        MutableShort mutableShort = new MutableShort(0);
        short result = mutableShort.getAndAdd((Number)1);
        Assert.assertEquals((long)0L, (long)result);
        Assert.assertEquals((long)1L, (long)mutableShort.shortValue());
    }

    @Test
    public void testAddAndGetValuePrimitive() {
        MutableShort mutableShort = new MutableShort(0);
        short result = mutableShort.addAndGet((short)1);
        Assert.assertEquals((long)1L, (long)result);
        Assert.assertEquals((long)1L, (long)mutableShort.shortValue());
    }

    @Test
    public void testAddAndGetValueObject() {
        MutableShort mutableShort = new MutableShort(0);
        short result = mutableShort.addAndGet((Number)1);
        Assert.assertEquals((long)1L, (long)result);
        Assert.assertEquals((long)1L, (long)mutableShort.shortValue());
    }

    @Test
    public void testSubtractValuePrimitive() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.subtract((short)1);
        Assert.assertEquals((long)0L, (long)mutNum.shortValue());
    }

    @Test
    public void testSubtractValueObject() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.subtract((Number)1);
        Assert.assertEquals((long)0L, (long)mutNum.shortValue());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"0", (Object)new MutableShort(0).toString());
        Assert.assertEquals((Object)"10", (Object)new MutableShort(10).toString());
        Assert.assertEquals((Object)"-123", (Object)new MutableShort(-123).toString());
    }
}

