/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.reflect.FieldUtilsTest;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.reflect.testbed.Annotated;
import org.apache.commons.lang3.reflect.testbed.GenericConsumer;
import org.apache.commons.lang3.reflect.testbed.GenericParent;
import org.apache.commons.lang3.reflect.testbed.StringParameterizedChild;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MethodUtilsTest {
    private TestBean testBean;
    private final Map<Class<?>, Class<?>[]> classCache = new HashMap();

    @Before
    public void setUp() throws Exception {
        this.testBean = new TestBean();
        this.classCache.clear();
    }

    @Test
    public void testConstructor() throws Exception {
        Assert.assertNotNull(MethodUtils.class.newInstance());
    }

    @Test
    public void verifyJavaVarargsOverloadingResolution() throws Exception {
        Assert.assertEquals((Object)"Byte...", (Object)TestBean.varOverload((byte)1, (byte)2));
        Assert.assertEquals((Object)"Short...", (Object)TestBean.varOverload((short)1, (short)2));
        Assert.assertEquals((Object)"Integer...", (Object)TestBean.varOverload(1, 2));
        Assert.assertEquals((Object)"Long...", (Object)TestBean.varOverload(1L, 2L));
        Assert.assertEquals((Object)"Float...", (Object)TestBean.varOverload(Float.valueOf(1.0f), Float.valueOf(2.0f)));
        Assert.assertEquals((Object)"Double...", (Object)TestBean.varOverload(1.0, 2.0));
        Assert.assertEquals((Object)"Character...", (Object)TestBean.varOverload(Character.valueOf('a'), Character.valueOf('b')));
        Assert.assertEquals((Object)"String...", (Object)TestBean.varOverload("a", "b"));
        Assert.assertEquals((Object)"Boolean...", (Object)TestBean.varOverload(true, false));
        Assert.assertEquals((Object)"Object...", (Object)TestBean.varOverload(1, "s"));
        Assert.assertEquals((Object)"Object...", (Object)TestBean.varOverload(1, true));
        Assert.assertEquals((Object)"Object...", (Object)TestBean.varOverload(1.1, true));
        Assert.assertEquals((Object)"Object...", (Object)TestBean.varOverload(Character.valueOf('c'), true));
        Assert.assertEquals((Object)"Number...", (Object)TestBean.varOverload(1, 1.1));
        Assert.assertEquals((Object)"Number...", (Object)TestBean.varOverload(1, 1L));
        Assert.assertEquals((Object)"Number...", (Object)TestBean.varOverload(1.0, Float.valueOf(1.0f)));
        Assert.assertEquals((Object)"Number...", (Object)TestBean.varOverload((short)1, (byte)1));
        Assert.assertEquals((Object)"Object...", (Object)TestBean.varOverload(1, Character.valueOf('c')));
        Assert.assertEquals((Object)"Object...", (Object)TestBean.varOverload(Character.valueOf('c'), "s"));
    }

    @Test
    public void testInvokeJavaVarargsOverloadingResolution() throws Exception {
        Assert.assertEquals((Object)"Byte...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{(byte)1, (byte)2}));
        Assert.assertEquals((Object)"Short...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{(short)1, (short)2}));
        Assert.assertEquals((Object)"Integer...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1, 2}));
        Assert.assertEquals((Object)"Long...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1L, 2L}));
        Assert.assertEquals((Object)"Float...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{Float.valueOf(1.0f), Float.valueOf(2.0f)}));
        Assert.assertEquals((Object)"Double...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1.0, 2.0}));
        Assert.assertEquals((Object)"Character...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{Character.valueOf('a'), Character.valueOf('b')}));
        Assert.assertEquals((Object)"String...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{"a", "b"}));
        Assert.assertEquals((Object)"Boolean...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{true, false}));
        Assert.assertEquals((Object)"Object...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1, "s"}));
        Assert.assertEquals((Object)"Object...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1, true}));
        Assert.assertEquals((Object)"Object...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1.1, true}));
        Assert.assertEquals((Object)"Object...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{Character.valueOf('c'), true}));
        Assert.assertEquals((Object)"Number...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1, 1.1}));
        Assert.assertEquals((Object)"Number...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1, 1L}));
        Assert.assertEquals((Object)"Number...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1.0, Float.valueOf(1.0f)}));
        Assert.assertEquals((Object)"Number...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{(short)1, (byte)1}));
        Assert.assertEquals((Object)"Object...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{1, Character.valueOf('c')}));
        Assert.assertEquals((Object)"Object...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])new Object[]{Character.valueOf('c'), "s"}));
        Assert.assertEquals((Object)"Object...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverload", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assert.assertEquals((Object)"Number...", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"numOverload", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
    }

    @Test
    public void testInvokeMethod() throws Exception {
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo"));
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])null));
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])null, (Class[])null));
        Assert.assertEquals((Object)"foo(String)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{""}));
        Assert.assertEquals((Object)"foo(Object)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{new Object()}));
        Assert.assertEquals((Object)"foo(Object)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{Boolean.TRUE}));
        Assert.assertEquals((Object)"foo(Integer)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        Assert.assertEquals((Object)"foo(int)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.BYTE_ONE}));
        Assert.assertEquals((Object)"foo(double)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.LONG_ONE}));
        Assert.assertEquals((Object)"foo(double)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}));
        Assert.assertEquals((Object)"foo(String...)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{"a", "b", "c"}));
        Assert.assertEquals((Object)"foo(String...)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{"a", "b", "c"}));
        Assert.assertEquals((Object)"foo(int, String...)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{5, "a", "b", "c"}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"String...", (Object)new String[]{"x", "y"}), MethodUtils.invokeMethod((Object)this.testBean, (String)"varOverloadEcho", (Object[])new Object[]{"x", "y"}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"Number...", (Object)new Number[]{17, 23, 42}), MethodUtils.invokeMethod((Object)this.testBean, (String)"varOverloadEcho", (Object[])new Object[]{17, 23, 42}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"String...", (Object)new String[]{"x", "y"}), MethodUtils.invokeMethod((Object)this.testBean, (String)"varOverloadEcho", (Object[])new Object[]{"x", "y"}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"Number...", (Object)new Number[]{17, 23, 42}), MethodUtils.invokeMethod((Object)this.testBean, (String)"varOverloadEcho", (Object[])new Object[]{17, 23, 42}));
    }

    @Test
    public void testInvokeExactMethod() throws Exception {
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo"));
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])null));
        Assert.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])null, (Class[])null));
        Assert.assertEquals((Object)"foo(String)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{""}));
        Assert.assertEquals((Object)"foo(Object)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{new Object()}));
        Assert.assertEquals((Object)"foo(Integer)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        Assert.assertEquals((Object)"foo(double)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}, (Class[])new Class[]{Double.TYPE}));
        try {
            MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.BYTE_ONE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.LONG_ONE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{Boolean.TRUE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Test
    public void testInvokeStaticMethod() throws Exception {
        Assert.assertEquals((Object)"bar()", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assert.assertEquals((Object)"bar()", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])null));
        Assert.assertEquals((Object)"bar()", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])null, (Class[])null));
        Assert.assertEquals((Object)"bar(String)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{""}));
        Assert.assertEquals((Object)"bar(Object)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{new Object()}));
        Assert.assertEquals((Object)"bar(Object)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{Boolean.TRUE}));
        Assert.assertEquals((Object)"bar(Integer)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        Assert.assertEquals((Object)"bar(int)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.BYTE_ONE}));
        Assert.assertEquals((Object)"bar(double)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.LONG_ONE}));
        Assert.assertEquals((Object)"bar(double)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}));
        Assert.assertEquals((Object)"bar(String...)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{"a", "b"}));
        Assert.assertEquals((Object)"bar(int, String...)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.INTEGER_ONE, "a", "b"}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"String...", (Object)new String[]{"x", "y"}), MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverloadEchoStatic", (Object[])new Object[]{"x", "y"}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"Number...", (Object)new Number[]{17, 23, 42}), MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverloadEchoStatic", (Object[])new Object[]{17, 23, 42}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"String...", (Object)new String[]{"x", "y"}), MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverloadEchoStatic", (Object[])new Object[]{"x", "y"}));
        TestBean.verify((ImmutablePair<String, Object[]>)new ImmutablePair((Object)"Number...", (Object)new Number[]{17, 23, 42}), MethodUtils.invokeStaticMethod(TestBean.class, (String)"varOverloadEchoStatic", (Object[])new Object[]{17, 23, 42}));
        try {
            MethodUtils.invokeStaticMethod(TestBean.class, (String)"does_not_exist", (Object[])new Object[0]);
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Test
    public void testInvokeExactStaticMethod() throws Exception {
        Assert.assertEquals((Object)"bar()", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assert.assertEquals((Object)"bar()", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])null));
        Assert.assertEquals((Object)"bar()", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])null, (Class[])null));
        Assert.assertEquals((Object)"bar(String)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{""}));
        Assert.assertEquals((Object)"bar(Object)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{new Object()}));
        Assert.assertEquals((Object)"bar(Integer)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        Assert.assertEquals((Object)"bar(double)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}, (Class[])new Class[]{Double.TYPE}));
        try {
            MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.BYTE_ONE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.LONG_ONE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{Boolean.TRUE});
            Assert.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAccessibleInterfaceMethod() throws Exception {
        Class[][] p;
        for (Class[] element : p = new Class[][]{ArrayUtils.EMPTY_CLASS_ARRAY, null}) {
            Method method = TestMutable.class.getMethod("getValue", element);
            Method accessibleMethod = MethodUtils.getAccessibleMethod((Method)method);
            Assert.assertNotSame((Object)accessibleMethod, (Object)method);
            Assert.assertSame(Mutable.class, accessibleMethod.getDeclaringClass());
        }
    }

    @Test
    public void testGetAccessibleMethodPrivateInterface() throws Exception {
        Method expected = TestBeanWithInterfaces.class.getMethod("foo", new Class[0]);
        Assert.assertNotNull((Object)expected);
        Method actual = MethodUtils.getAccessibleMethod(TestBeanWithInterfaces.class, (String)"foo", (Class[])new Class[0]);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testGetAccessibleInterfaceMethodFromDescription() throws Exception {
        Class[][] p;
        for (Class[] element : p = new Class[][]{ArrayUtils.EMPTY_CLASS_ARRAY, null}) {
            Method accessibleMethod = MethodUtils.getAccessibleMethod(TestMutable.class, (String)"getValue", (Class[])element);
            Assert.assertSame(Mutable.class, accessibleMethod.getDeclaringClass());
        }
    }

    @Test
    public void testGetAccessiblePublicMethod() throws Exception {
        Assert.assertSame(MutableObject.class, MethodUtils.getAccessibleMethod((Method)MutableObject.class.getMethod("getValue", ArrayUtils.EMPTY_CLASS_ARRAY)).getDeclaringClass());
    }

    @Test
    public void testGetAccessiblePublicMethodFromDescription() throws Exception {
        Assert.assertSame(MutableObject.class, MethodUtils.getAccessibleMethod(MutableObject.class, (String)"getValue", (Class[])ArrayUtils.EMPTY_CLASS_ARRAY).getDeclaringClass());
    }

    @Test
    public void testGetAccessibleMethodInaccessible() throws Exception {
        Method expected = TestBean.class.getDeclaredMethod("privateStuff", new Class[0]);
        Method actual = MethodUtils.getAccessibleMethod((Method)expected);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testGetMatchingAccessibleMethod() throws Exception {
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", ArrayUtils.EMPTY_CLASS_ARRAY, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", null, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(String.class), this.singletonArray(String.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Object.class), this.singletonArray(Object.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Boolean.class), this.singletonArray(Object.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Byte.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Byte.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Short.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Short.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Character.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Character.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Integer.class), this.singletonArray(Integer.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Integer.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Long.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Long.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Float.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Float.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Double.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Double.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Double.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", new Class[]{String.class, String.class}, new Class[]{String[].class});
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", new Class[]{Integer.TYPE, String.class, String.class}, new Class[]{Integer.class, String[].class});
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testOne", this.singletonArray(ParentObject.class), this.singletonArray(ParentObject.class));
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testOne", this.singletonArray(ChildObject.class), this.singletonArray(ParentObject.class));
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testTwo", this.singletonArray(ParentObject.class), this.singletonArray(GrandParentObject.class));
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testTwo", this.singletonArray(ChildObject.class), this.singletonArray(ChildInterface.class));
    }

    @Test
    public void testNullArgument() {
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "oneParameter", this.singletonArray(null), this.singletonArray(String.class));
    }

    @Test
    public void testGetOverrideHierarchyIncludingInterfaces() {
        Method method = MethodUtils.getAccessibleMethod(StringParameterizedChild.class, (String)"consume", (Class[])new Class[]{String.class});
        Iterator<MethodDescriptor> expected = Arrays.asList(new MethodDescriptor(StringParameterizedChild.class, "consume", new Type[]{String.class}), new MethodDescriptor(GenericParent.class, "consume", GenericParent.class.getTypeParameters()[0]), new MethodDescriptor(GenericConsumer.class, "consume", GenericConsumer.class.getTypeParameters()[0])).iterator();
        for (Method m : MethodUtils.getOverrideHierarchy((Method)method, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE)) {
            Assert.assertTrue((boolean)expected.hasNext());
            MethodDescriptor md = expected.next();
            Assert.assertEquals(md.declaringClass, m.getDeclaringClass());
            Assert.assertEquals((Object)md.name, (Object)m.getName());
            Assert.assertEquals((long)md.parameterTypes.length, (long)m.getParameterTypes().length);
            for (int i = 0; i < md.parameterTypes.length; ++i) {
                Assert.assertTrue((boolean)TypeUtils.equals((Type)md.parameterTypes[i], (Type)m.getGenericParameterTypes()[i]));
            }
        }
        Assert.assertFalse((boolean)expected.hasNext());
    }

    @Test
    public void testGetOverrideHierarchyExcludingInterfaces() {
        Method method = MethodUtils.getAccessibleMethod(StringParameterizedChild.class, (String)"consume", (Class[])new Class[]{String.class});
        Iterator<MethodDescriptor> expected = Arrays.asList(new MethodDescriptor(StringParameterizedChild.class, "consume", new Type[]{String.class}), new MethodDescriptor(GenericParent.class, "consume", GenericParent.class.getTypeParameters()[0])).iterator();
        for (Method m : MethodUtils.getOverrideHierarchy((Method)method, (ClassUtils.Interfaces)ClassUtils.Interfaces.EXCLUDE)) {
            Assert.assertTrue((boolean)expected.hasNext());
            MethodDescriptor md = expected.next();
            Assert.assertEquals(md.declaringClass, m.getDeclaringClass());
            Assert.assertEquals((Object)md.name, (Object)m.getName());
            Assert.assertEquals((long)md.parameterTypes.length, (long)m.getParameterTypes().length);
            for (int i = 0; i < md.parameterTypes.length; ++i) {
                Assert.assertTrue((boolean)TypeUtils.equals((Type)md.parameterTypes[i], (Type)m.getGenericParameterTypes()[i]));
            }
        }
        Assert.assertFalse((boolean)expected.hasNext());
    }

    @Test
    @Annotated
    public void testGetMethodsWithAnnotation() throws NoSuchMethodException {
        Assert.assertArrayEquals((Object[])new Method[0], (Object[])MethodUtils.getMethodsWithAnnotation(Object.class, Annotated.class));
        Method[] methodsWithAnnotation = MethodUtils.getMethodsWithAnnotation(MethodUtilsTest.class, Annotated.class);
        Assert.assertEquals((long)2L, (long)methodsWithAnnotation.length);
        Assert.assertThat((Object)methodsWithAnnotation, (Matcher)Matchers.hasItemInArray((Object)MethodUtilsTest.class.getMethod("testGetMethodsWithAnnotation", new Class[0])));
        Assert.assertThat((Object)methodsWithAnnotation, (Matcher)Matchers.hasItemInArray((Object)MethodUtilsTest.class.getMethod("testGetMethodsListWithAnnotation", new Class[0])));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetMethodsWithAnnotationIllegalArgumentException1() {
        MethodUtils.getMethodsWithAnnotation(FieldUtilsTest.class, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetMethodsWithAnnotationIllegalArgumentException2() {
        MethodUtils.getMethodsWithAnnotation(null, Annotated.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetMethodsWithAnnotationIllegalArgumentException3() {
        MethodUtils.getMethodsWithAnnotation(null, null);
    }

    @Test
    @Annotated
    public void testGetMethodsListWithAnnotation() throws NoSuchMethodException {
        Assert.assertEquals((long)0L, (long)MethodUtils.getMethodsListWithAnnotation(Object.class, Annotated.class).size());
        List methodWithAnnotation = MethodUtils.getMethodsListWithAnnotation(MethodUtilsTest.class, Annotated.class);
        Assert.assertEquals((long)2L, (long)methodWithAnnotation.size());
        Assert.assertThat((Object)methodWithAnnotation, (Matcher)Matchers.hasItems((Object[])new Method[]{MethodUtilsTest.class.getMethod("testGetMethodsWithAnnotation", new Class[0]), MethodUtilsTest.class.getMethod("testGetMethodsListWithAnnotation", new Class[0])}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetMethodsListWithAnnotationIllegalArgumentException1() {
        MethodUtils.getMethodsListWithAnnotation(FieldUtilsTest.class, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetMethodsListWithAnnotationIllegalArgumentException2() {
        MethodUtils.getMethodsListWithAnnotation(null, Annotated.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetMethodsListWithAnnotationIllegalArgumentException3() {
        MethodUtils.getMethodsListWithAnnotation(null, null);
    }

    private void expectMatchingAccessibleMethodParameterTypes(Class<?> cls, String methodName, Class<?>[] requestTypes, Class<?>[] actualTypes) {
        Method m = MethodUtils.getMatchingAccessibleMethod(cls, (String)methodName, (Class[])requestTypes);
        Assert.assertNotNull((String)("could not find any matches for " + methodName + " (" + (requestTypes == null ? null : this.toString(requestTypes)) + ")"), (Object)m);
        Assert.assertTrue((String)(this.toString(m.getParameterTypes()) + " not equals " + this.toString(actualTypes)), (boolean)Arrays.equals(actualTypes, m.getParameterTypes()));
    }

    private String toString(Class<?>[] c) {
        return Arrays.asList(c).toString();
    }

    private Class<?>[] singletonArray(Class<?> c) {
        Class<?>[] result = this.classCache.get(c);
        if (result == null) {
            result = new Class[]{c};
            this.classCache.put(c, result);
        }
        return result;
    }

    @Test
    public void testVarArgsUnboxing() throws Exception {
        TestBean testBean = new TestBean();
        int[] actual = (int[])MethodUtils.invokeMethod((Object)testBean, (String)"unboxing", (Object[])new Object[]{1, 2});
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])actual);
    }

    @Test
    public void testInvokeMethodForceAccessNoArgs() throws Exception {
        Method privateStringStuffMethod = MethodUtils.getMatchingMethod(TestBean.class, (String)"privateStringStuff", (Class[])new Class[0]);
        Assert.assertFalse((boolean)privateStringStuffMethod.isAccessible());
        Assert.assertEquals((Object)"privateStringStuff()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (boolean)true, (String)"privateStringStuff"));
        Assert.assertFalse((boolean)privateStringStuffMethod.isAccessible());
    }

    @Test
    public void testInvokeMethodForceAccessWithArgs() throws Exception {
        Assert.assertEquals((Object)"privateStringStuff(Integer)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (boolean)true, (String)"privateStringStuff", (Object[])new Object[]{5}));
        Assert.assertEquals((Object)"privateStringStuff(double)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (boolean)true, (String)"privateStringStuff", (Object[])new Object[]{5.0}));
        Assert.assertEquals((Object)"privateStringStuff(String)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (boolean)true, (String)"privateStringStuff", (Object[])new Object[]{"Hi There"}));
        Assert.assertEquals((Object)"privateStringStuff(Object)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (boolean)true, (String)"privateStringStuff", (Object[])new Object[]{new Date()}));
    }

    @Test
    public void testDistance() throws Exception {
        Method distanceMethod = MethodUtils.getMatchingMethod(MethodUtils.class, (String)"distance", (Class[])new Class[]{Class[].class, Class[].class});
        distanceMethod.setAccessible(true);
        Assert.assertEquals((Object)-1, (Object)distanceMethod.invoke(null, new Class[]{String.class}, new Class[]{Date.class}));
        Assert.assertEquals((Object)0, (Object)distanceMethod.invoke(null, new Class[]{Date.class}, new Class[]{Date.class}));
        Assert.assertEquals((Object)1, (Object)distanceMethod.invoke(null, new Class[]{Integer.class}, new Class[]{ClassUtils.wrapperToPrimitive(Integer.class)}));
        Assert.assertEquals((Object)2, (Object)distanceMethod.invoke(null, new Class[]{Integer.class}, new Class[]{Object.class}));
        distanceMethod.setAccessible(false);
    }

    private static class MethodDescriptor {
        final Class<?> declaringClass;
        final String name;
        final Type[] parameterTypes;

        MethodDescriptor(Class<?> declaringClass, String name, Type ... parameterTypes) {
            this.declaringClass = declaringClass;
            this.name = name;
            this.parameterTypes = parameterTypes;
        }
    }

    public static class ChildObject
    extends ParentObject
    implements ChildInterface {
    }

    public static class ParentObject
    extends GrandParentObject {
    }

    public static class GrandParentObject {
    }

    static interface ChildInterface {
    }

    public static class InheritanceBean {
        public void testOne(Object obj) {
        }

        public void testOne(GrandParentObject obj) {
        }

        public void testOne(ParentObject obj) {
        }

        public void testTwo(Object obj) {
        }

        public void testTwo(GrandParentObject obj) {
        }

        public void testTwo(ChildInterface obj) {
        }
    }

    private static class TestMutable
    implements Mutable<Object> {
        private TestMutable() {
        }

        public Object getValue() {
            return null;
        }

        public void setValue(Object value) {
        }
    }

    public static class TestBean {
        public static String bar() {
            return "bar()";
        }

        public static String bar(int i) {
            return "bar(int)";
        }

        public static String bar(Integer i) {
            return "bar(Integer)";
        }

        public static String bar(double d) {
            return "bar(double)";
        }

        public static String bar(String s) {
            return "bar(String)";
        }

        public static String bar(Object o) {
            return "bar(Object)";
        }

        public static String bar(String ... s) {
            return "bar(String...)";
        }

        public static String bar(Integer i, String ... s) {
            return "bar(int, String...)";
        }

        public static void oneParameterStatic(String s) {
        }

        private void privateStuff() {
        }

        private String privateStringStuff() {
            return "privateStringStuff()";
        }

        private String privateStringStuff(int i) {
            return "privateStringStuff(int)";
        }

        private String privateStringStuff(Integer i) {
            return "privateStringStuff(Integer)";
        }

        private String privateStringStuff(double d) {
            return "privateStringStuff(double)";
        }

        private String privateStringStuff(String s) {
            return "privateStringStuff(String)";
        }

        private String privateStringStuff(Object s) {
            return "privateStringStuff(Object)";
        }

        public String foo() {
            return "foo()";
        }

        public String foo(int i) {
            return "foo(int)";
        }

        public String foo(Integer i) {
            return "foo(Integer)";
        }

        public String foo(double d) {
            return "foo(double)";
        }

        public String foo(String s) {
            return "foo(String)";
        }

        public String foo(Object o) {
            return "foo(Object)";
        }

        public String foo(String ... s) {
            return "foo(String...)";
        }

        public String foo(Integer i, String ... s) {
            return "foo(int, String...)";
        }

        public void oneParameter(String s) {
        }

        public String foo(Object ... s) {
            return "foo(Object...)";
        }

        public int[] unboxing(int ... values) {
            return values;
        }

        public static String varOverload(Byte ... args) {
            return "Byte...";
        }

        public static String varOverload(Character ... args) {
            return "Character...";
        }

        public static String varOverload(Short ... args) {
            return "Short...";
        }

        public static String varOverload(Boolean ... args) {
            return "Boolean...";
        }

        public static String varOverload(Float ... args) {
            return "Float...";
        }

        public static String varOverload(Double ... args) {
            return "Double...";
        }

        public static String varOverload(Integer ... args) {
            return "Integer...";
        }

        public static String varOverload(Long ... args) {
            return "Long...";
        }

        public static String varOverload(Number ... args) {
            return "Number...";
        }

        public static String varOverload(Object ... args) {
            return "Object...";
        }

        public static String varOverload(String ... args) {
            return "String...";
        }

        public static String numOverload(Byte ... args) {
            return "Byte...";
        }

        public static String numOverload(Short ... args) {
            return "Short...";
        }

        public static String numOverload(Float ... args) {
            return "Float...";
        }

        public static String numOverload(Double ... args) {
            return "Double...";
        }

        public static String numOverload(Integer ... args) {
            return "Integer...";
        }

        public static String numOverload(Long ... args) {
            return "Long...";
        }

        public static String numOverload(Number ... args) {
            return "Number...";
        }

        public ImmutablePair<String, Object[]> varOverloadEcho(String ... args) {
            return new ImmutablePair((Object)"String...", (Object)args);
        }

        public ImmutablePair<String, Object[]> varOverloadEcho(Number ... args) {
            return new ImmutablePair((Object)"Number...", (Object)args);
        }

        public static ImmutablePair<String, Object[]> varOverloadEchoStatic(String ... args) {
            return new ImmutablePair((Object)"String...", (Object)args);
        }

        public static ImmutablePair<String, Object[]> varOverloadEchoStatic(Number ... args) {
            return new ImmutablePair((Object)"Number...", (Object)args);
        }

        static void verify(ImmutablePair<String, Object[]> a, ImmutablePair<String, Object[]> b) {
            Assert.assertEquals((Object)a.getLeft(), (Object)b.getLeft());
            Assert.assertArrayEquals((Object[])((Object[])a.getRight()), (Object[])((Object[])b.getRight()));
        }

        static void verify(ImmutablePair<String, Object[]> a, Object _b) {
            ImmutablePair b = (ImmutablePair)_b;
            TestBean.verify(a, (ImmutablePair<String, Object[]>)b);
        }
    }

    static class TestBeanWithInterfaces
    implements PrivateInterface {
        TestBeanWithInterfaces() {
        }

        public String foo() {
            return "foo()";
        }
    }

    private static interface PrivateInterface {
    }
}

