/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.lang3.tuple.MutablePair;
import org.junit.Assert;
import org.junit.Test;

public class MutablePairTest {
    @Test
    public void testBasic() throws Exception {
        MutablePair pair = new MutablePair((Object)0, (Object)"foo");
        Assert.assertEquals((long)0L, (long)((Integer)pair.getLeft()).intValue());
        Assert.assertEquals((Object)"foo", (Object)pair.getRight());
        MutablePair pair2 = new MutablePair(null, (Object)"bar");
        Assert.assertNull((Object)pair2.getLeft());
        Assert.assertEquals((Object)"bar", (Object)pair2.getRight());
    }

    @Test
    public void testDefault() throws Exception {
        MutablePair pair = new MutablePair();
        Assert.assertNull((Object)pair.getLeft());
        Assert.assertNull((Object)pair.getRight());
    }

    @Test
    public void testMutate() throws Exception {
        MutablePair pair = new MutablePair((Object)0, (Object)"foo");
        pair.setLeft((Object)42);
        pair.setRight((Object)"bar");
        Assert.assertEquals((long)42L, (long)((Integer)pair.getLeft()).intValue());
        Assert.assertEquals((Object)"bar", (Object)pair.getRight());
    }

    @Test
    public void testPairOf() throws Exception {
        MutablePair pair = MutablePair.of((Object)0, (Object)"foo");
        Assert.assertEquals((long)0L, (long)((Integer)pair.getLeft()).intValue());
        Assert.assertEquals((Object)"foo", (Object)pair.getRight());
        MutablePair pair2 = MutablePair.of(null, (Object)"bar");
        Assert.assertNull((Object)pair2.getLeft());
        Assert.assertEquals((Object)"bar", (Object)pair2.getRight());
    }

    @Test
    public void testEquals() throws Exception {
        Assert.assertEquals((Object)MutablePair.of(null, (Object)"foo"), (Object)MutablePair.of(null, (Object)"foo"));
        Assert.assertFalse((boolean)MutablePair.of((Object)"foo", (Object)0).equals((Object)MutablePair.of((Object)"foo", null)));
        Assert.assertFalse((boolean)MutablePair.of((Object)"foo", (Object)"bar").equals((Object)MutablePair.of((Object)"xyz", (Object)"bar")));
        MutablePair p = MutablePair.of((Object)"foo", (Object)"bar");
        Assert.assertTrue((boolean)p.equals((Object)p));
        Assert.assertFalse((boolean)p.equals(new Object()));
    }

    @Test
    public void testHashCode() throws Exception {
        Assert.assertEquals((long)MutablePair.of(null, (Object)"foo").hashCode(), (long)MutablePair.of(null, (Object)"foo").hashCode());
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertEquals((Object)"(null,null)", (Object)MutablePair.of(null, null).toString());
        Assert.assertEquals((Object)"(null,two)", (Object)MutablePair.of(null, (Object)"two").toString());
        Assert.assertEquals((Object)"(one,null)", (Object)MutablePair.of((Object)"one", null).toString());
        Assert.assertEquals((Object)"(one,two)", (Object)MutablePair.of((Object)"one", (Object)"two").toString());
    }

    @Test
    public void testSerialization() throws Exception {
        MutablePair origPair = MutablePair.of((Object)0, (Object)"foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(origPair);
        MutablePair deserializedPair = (MutablePair)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        Assert.assertEquals((Object)origPair, (Object)deserializedPair);
        Assert.assertEquals((long)origPair.hashCode(), (long)deserializedPair.hashCode());
    }
}

