/*
 * Decompiled with CFR 0.152.
 */
package almaligner;

import almaligner.GenericDialog;
import almaligner.Main;
import almaligner.MainFrame;
import almaligner.ProgressBarUpdater;
import almaligner.SegmentsEvaluation;
import almaligner.SegmentsEvaluator;
import almaligner.TMXHandler;
import almaligner.TranslationUnit;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Anymaliagn
implements Runnable {
    private final File inputFile;
    private File corpus;
    private final String anymalignPath;
    private int stopAfterSeconds;
    private int stopWhenAlignments;
    private File xlsxOutputFile;
    private File tsvDiscardFile;
    private final MainFrame mainFrame;
    private ArrayList<String> languages;
    private Process process;

    public Anymaliagn(File inputFile, MainFrame mainFrame) {
        this.inputFile = inputFile;
        this.mainFrame = mainFrame;
        this.setXlsxFileName(0);
        this.setTsvFileName(0);
        this.anymalignPath = this.findAnymalignPath();
    }

    public int getStopAfterSeconds() {
        return this.stopAfterSeconds;
    }

    public void setStopAfterSeconds(int stopAfterSeconds) {
        this.stopAfterSeconds = stopAfterSeconds;
    }

    public int getStopWhenAlignments() {
        return this.stopWhenAlignments;
    }

    public void setStopWhenAlignments(int stopWhenAlignments) {
        this.stopWhenAlignments = stopWhenAlignments;
    }

    public Process getProcess() {
        return this.process;
    }

    @Override
    public void run() {
        Integer stopBelowAlignments;
        this.corpus = FilenameUtils.getExtension((String)this.inputFile.toString()).toLowerCase().equals("tmx") ? this.convertTMXtoTSV(this.inputFile) : this.inputFile;
        this.determineLanguages(this.corpus);
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(this.anymalignPath);
        parameters.add(this.corpus.getPath());
        Integer stopAfterSecs = (Integer)this.mainFrame.getStopSecondsSpinner().getValue();
        if (stopAfterSecs > 0) {
            parameters.add("-t");
            parameters.add(stopAfterSecs.toString());
        }
        if ((stopBelowAlignments = (Integer)this.mainFrame.getStopAlignmentsSpinner().getValue()) > 0) {
            parameters.add("-a");
            parameters.add(stopBelowAlignments.toString());
        }
        if (this.mainFrame.getComputeWeightsCheckBox().isSelected()) {
            parameters.add("-w");
        }
        String[] params = new String[parameters.size()];
        params = parameters.toArray(params);
        ProgressBarUpdater progressBarUpdater = new ProgressBarUpdater(this.mainFrame.getProgressBar(), (Integer)this.mainFrame.getStopSecondsSpinner().getValue());
        Thread progressBarUpdaterThread = new Thread(progressBarUpdater);
        progressBarUpdaterThread.start();
        try {
            this.process = Runtime.getRuntime().exec(params);
            BufferedReader stdout = new BufferedReader(new InputStreamReader(this.process.getInputStream(), Charset.forName("UTF-8")));
            PrintWriter discardWriter = new PrintWriter(this.tsvDiscardFile, "UTF-8");
            SegmentsEvaluator segmentEvaluator = new SegmentsEvaluator(this.languages, this.mainFrame.getComputeWeightsCheckBox().isSelected());
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                String line;
                XSSFSheet sheet = workbook.createSheet("Results");
                int rowNumber = 0;
                while ((line = stdout.readLine()) != null) {
                    int n;
                    String[] fields = line.split("\t");
                    int numberOfLanguages = fields.length - 3;
                    int columnCount = 0;
                    if (rowNumber == 0) {
                        XSSFRow rowhead = sheet.createRow(0);
                        for (n = 0; n < numberOfLanguages; ++n) {
                            rowhead.createCell(columnCount).setCellValue(this.languages.get(n));
                            ++columnCount;
                        }
                        if (this.mainFrame.getComputeWeightsCheckBox().isSelected()) {
                            for (n = 0; n < numberOfLanguages; ++n) {
                                rowhead.createCell(columnCount).setCellValue("Lexical weight " + this.languages.get(n));
                                ++columnCount;
                            }
                        }
                        for (n = 0; n < numberOfLanguages; ++n) {
                            rowhead.createCell(columnCount).setCellValue("Translation probability " + this.languages.get(n));
                            ++columnCount;
                        }
                        rowhead.createCell(columnCount).setCellValue("Frequency");
                        ++rowNumber;
                    }
                    XSSFRow row = sheet.createRow(rowNumber);
                    columnCount = 0;
                    for (n = 0; n < fields.length; ++n) {
                        int l;
                        if (n == fields.length - 3) {
                            if (!this.mainFrame.getComputeWeightsCheckBox().isSelected()) continue;
                            String[] lexWeights = fields[n].split(" ");
                            for (l = 0; l < lexWeights.length; ++l) {
                                row.createCell(columnCount, CellType.NUMERIC).setCellValue(Double.parseDouble(lexWeights[l]));
                                ++columnCount;
                            }
                            continue;
                        }
                        if (n == fields.length - 2) {
                            String[] transProb = fields[n].split(" ");
                            for (l = 0; l < transProb.length; ++l) {
                                row.createCell(columnCount, CellType.NUMERIC).setCellValue(Double.parseDouble(transProb[l]));
                                ++columnCount;
                            }
                            continue;
                        }
                        if (n == fields.length - 1) {
                            row.createCell(columnCount, CellType.NUMERIC).setCellValue((double)Integer.parseInt(fields[n]));
                            ++columnCount;
                            continue;
                        }
                        row.createCell(columnCount, CellType.STRING).setCellValue(fields[n]);
                        ++columnCount;
                    }
                    SegmentsEvaluation eval = segmentEvaluator.evaluate(row);
                    if (!eval.equals((Object)SegmentsEvaluation.ACCEPTABLE)) {
                        sheet.removeRow((Row)row);
                        discardWriter.println(line + "\t" + (Object)((Object)eval));
                        continue;
                    }
                    ++rowNumber;
                }
                FileOutputStream fileOut = new FileOutputStream(this.xlsxOutputFile);
                workbook.write((OutputStream)fileOut);
                fileOut.close();
            }
            discardWriter.close();
            stdout.close();
            progressBarUpdater.setComplete(true);
            String message = "Process complete, you'll find the files in the same folder as the source file.";
            GenericDialog dialog = new GenericDialog((Frame)this.mainFrame, true, message, this.xlsxOutputFile);
            dialog.setSize(330, 150);
            dialog.setVisible(true);
            this.mainFrame.getStartButton().setEnabled(true);
        }
        catch (IOException ex) {
            Logger.getLogger(Anymaliagn.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setXlsxFileName(int iteration) {
        String iterationString = "";
        if (iteration > 0) {
            iterationString = " (" + iteration + ")";
        }
        this.xlsxOutputFile = new File(FilenameUtils.getFullPath((String)this.inputFile.toString()) + File.separator + FilenameUtils.getBaseName((String)this.inputFile.toString()) + " alignments" + iterationString + ".xlsx");
        if (this.xlsxOutputFile.exists()) {
            this.setXlsxFileName(++iteration);
        }
    }

    private void setTsvFileName(int iteration) {
        String iterationString = "";
        if (iteration > 0) {
            iterationString = " (" + iteration + ")";
        }
        this.tsvDiscardFile = new File(FilenameUtils.getFullPath((String)this.inputFile.toString()) + File.separator + FilenameUtils.getBaseName((String)this.inputFile.toString()) + " discard" + iterationString + ".tsv");
        if (this.tsvDiscardFile.exists()) {
            this.setTsvFileName(++iteration);
        }
    }

    private File convertTMXtoTSV(File tmxFile) {
        File tsvFile = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXParser saxParser = factory.newSAXParser();
            TMXHandler tmxHandler = new TMXHandler();
            saxParser.parse(tmxFile, (DefaultHandler)tmxHandler);
            List<TranslationUnit> tus = tmxHandler.getTuList();
            tsvFile = File.createTempFile(FilenameUtils.getBaseName((String)tmxFile.getName()), ".tsv");
            PrintWriter writer = new PrintWriter(tsvFile, "UTF-8");
            String headerline = tus.get(0).getLanguages().get(0) + "\t" + tus.get(0).getLanguages().get(1) + "\n";
            writer.write(headerline);
            for (TranslationUnit tu : tus) {
                writer.write(this.cleanString(tu.getSegments().get(0)) + "\t" + this.cleanString(tu.getSegments().get(1)) + "\n");
            }
            writer.flush();
            writer.close();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(Anymaliagn.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(Anymaliagn.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Anymaliagn.class.getName()).log(Level.SEVERE, null, ex);
        }
        return tsvFile;
    }

    private String findAnymalignPath() {
        String path = null;
        try {
            File rootAppPath = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            String os = null;
            String binaryName = null;
            if (SystemUtils.IS_OS_MAC) {
                os = "mac";
                binaryName = "anymalign";
            } else if (SystemUtils.IS_OS_LINUX) {
                os = "linux";
                binaryName = "anymalign";
            } else if (SystemUtils.IS_OS_WINDOWS) {
                os = "windows";
                binaryName = "anymalign.exe";
            } else {
                System.err.println("Your OS is not supported");
                System.exit(0);
            }
            rootAppPath = rootAppPath.getParentFile().getName().equals("build") ? rootAppPath.getParentFile().getParentFile() : rootAppPath.getParentFile();
            path = rootAppPath + File.separator + "resources" + File.separator + os + File.separator + binaryName;
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        return path;
    }

    private String cleanString(String string) {
        string = string.replaceAll("\r\n", "\n");
        string = string.replaceAll("\r", "\n");
        string = string.replaceAll("\n", " ");
        string = string.replaceAll("\t", " ");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determineLanguages(File corpus) {
        this.languages = new ArrayList();
        BufferedReader brTest = null;
        try {
            String[] langs;
            brTest = new BufferedReader(new FileReader(corpus));
            String line = brTest.readLine();
            for (String lang : langs = line.split("\t")) {
                this.languages.add(lang.substring(0, 2).toLowerCase());
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Anymaliagn.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Anymaliagn.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                brTest.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Anymaliagn.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

