/*
 * Decompiled with CFR 0.152.
 */
package almaligner;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class GenericDialog
extends JDialog {
    private File xlsxFile;
    private JPanel jPanel1;
    private JLabel messageLabel;
    private JButton openAlignmentsButton;
    private JButton openFolderButton;

    public GenericDialog(Frame parent, boolean modal, String message, File xlsxFile) {
        super(parent, modal);
        this.initComponents();
        this.centerOnScreen();
        this.xlsxFile = xlsxFile;
        this.messageLabel.setText("<html>" + message + "</html>");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.messageLabel = new JLabel();
        this.openAlignmentsButton = new JButton();
        this.openFolderButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.messageLabel.setIcon(new ImageIcon(this.getClass().getResource("/gui/resources/info.png")));
        this.openAlignmentsButton.setText("Open alignments");
        this.openAlignmentsButton.setMaximumSize(new Dimension(135, 30));
        this.openAlignmentsButton.setMinimumSize(new Dimension(135, 30));
        this.openAlignmentsButton.setPreferredSize(new Dimension(135, 30));
        this.openAlignmentsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenericDialog.this.openAlignmentsButtonActionPerformed(evt);
            }
        });
        this.openFolderButton.setText("Open folder");
        this.openFolderButton.setMaximumSize(new Dimension(135, 30));
        this.openFolderButton.setMinimumSize(new Dimension(135, 30));
        this.openFolderButton.setPreferredSize(new Dimension(135, 30));
        this.openFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenericDialog.this.openFolderButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.openAlignmentsButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 32, Short.MAX_VALUE).addComponent(this.openFolderButton, -2, 151, -2)).addComponent(this.messageLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel, -1, 102, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.openAlignmentsButton, -2, -1, -2).addComponent(this.openFolderButton, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void openAlignmentsButtonActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().open(this.xlsxFile);
        }
        catch (IOException ex) {
            Logger.getLogger(GenericDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.dispose();
    }

    private void openFolderButtonActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().open(this.xlsxFile.getParentFile());
        }
        catch (IOException ex) {
            Logger.getLogger(GenericDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(GenericDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(GenericDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(GenericDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(GenericDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GenericDialog dialog = new GenericDialog((Frame)new JFrame(), true, null, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private void centerOnScreen() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int initialXPosition = (dim.width - this.getSize().width) / 2;
        int initialYPosition = (dim.height - this.getSize().height) / 2;
        this.setLocation(initialXPosition, initialYPosition);
    }
}

