/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf.examples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.Section;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.util.HexDump;

public final class ReadCustomPropertySets {
    private ReadCustomPropertySets() {
    }

    public static void main(String[] args) throws IOException {
        String filename = args[0];
        POIFSReader r = new POIFSReader();
        r.registerListener((POIFSReaderListener)new MyPOIFSReaderListener());
        r.read(new File(filename));
    }

    private static void out(String msg) {
        System.out.println(msg);
    }

    private static String hex(byte[] bytes) {
        return HexDump.dump((byte[])bytes, (long)0L, (int)0);
    }

    static class MyPOIFSReaderListener
    implements POIFSReaderListener {
        MyPOIFSReaderListener() {
        }

        public void processPOIFSReaderEvent(POIFSReaderEvent event) {
            PropertySet ps;
            try {
                ps = PropertySetFactory.create((InputStream)event.getStream());
            }
            catch (NoPropertySetStreamException ex) {
                ReadCustomPropertySets.out("No property set stream: \"" + event.getPath() + event.getName() + "\"");
                return;
            }
            catch (Exception ex) {
                throw new RuntimeException("Property set stream \"" + event.getPath() + event.getName() + "\": " + ex);
            }
            ReadCustomPropertySets.out("Property set stream \"" + event.getPath() + event.getName() + "\":");
            long sectionCount = ps.getSectionCount();
            ReadCustomPropertySets.out("   No. of sections: " + sectionCount);
            List sections = ps.getSections();
            int nr = 0;
            for (Section sec : sections) {
                Property[] properties;
                ReadCustomPropertySets.out("   Section " + nr++ + ":");
                String s = ReadCustomPropertySets.hex(sec.getFormatID().getBytes());
                s = s.substring(0, s.length() - 1);
                ReadCustomPropertySets.out("      Format ID: " + s);
                int propertyCount = sec.getPropertyCount();
                ReadCustomPropertySets.out("      No. of properties: " + propertyCount);
                for (Property p : properties = sec.getProperties()) {
                    long id = p.getID();
                    long type = p.getType();
                    Object value = p.getValue();
                    ReadCustomPropertySets.out("      Property ID: " + id + ", type: " + type + ", value: " + value);
                }
            }
        }
    }
}

