/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.arj.ArjArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.junit.Assert;
import org.junit.Test;

public final class DetectArchiverTestCase
extends AbstractTestCase {
    final ClassLoader classLoader = this.getClass().getClassLoader();

    @Test
    public void testDetectionNotArchive() throws IOException {
        try {
            this.getStreamFor("test.txt");
            Assert.fail((String)"Expected ArchiveException");
        }
        catch (ArchiveException archiveException) {
            // empty catch block
        }
    }

    @Test
    public void testCOMPRESS117() throws Exception {
        ArchiveInputStream tar = this.getStreamFor("COMPRESS-117.tar");
        Assert.assertNotNull((Object)tar);
        Assert.assertTrue((boolean)(tar instanceof TarArchiveInputStream));
    }

    @Test
    public void testCOMPRESS335() throws Exception {
        ArchiveInputStream tar = this.getStreamFor("COMPRESS-335.tar");
        Assert.assertNotNull((Object)tar);
        Assert.assertTrue((boolean)(tar instanceof TarArchiveInputStream));
    }

    @Test
    public void testDetection() throws Exception {
        ArchiveInputStream ar = this.getStreamFor("bla.ar");
        Assert.assertNotNull((Object)ar);
        Assert.assertTrue((boolean)(ar instanceof ArArchiveInputStream));
        ArchiveInputStream tar = this.getStreamFor("bla.tar");
        Assert.assertNotNull((Object)tar);
        Assert.assertTrue((boolean)(tar instanceof TarArchiveInputStream));
        ArchiveInputStream zip = this.getStreamFor("bla.zip");
        Assert.assertNotNull((Object)zip);
        Assert.assertTrue((boolean)(zip instanceof ZipArchiveInputStream));
        ArchiveInputStream jar = this.getStreamFor("bla.jar");
        Assert.assertNotNull((Object)jar);
        Assert.assertTrue((boolean)(jar instanceof ZipArchiveInputStream));
        ArchiveInputStream cpio = this.getStreamFor("bla.cpio");
        Assert.assertNotNull((Object)cpio);
        Assert.assertTrue((boolean)(cpio instanceof CpioArchiveInputStream));
        ArchiveInputStream arj = this.getStreamFor("bla.arj");
        Assert.assertNotNull((Object)arj);
        Assert.assertTrue((boolean)(arj instanceof ArjArchiveInputStream));
    }

    private ArchiveInputStream getStreamFor(String resource) throws ArchiveException, IOException {
        return this.factory.createArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(DetectArchiverTestCase.getFile(resource))));
    }

    @Test
    public void testEmptyCpioArchive() throws Exception {
        this.checkEmptyArchive("cpio");
    }

    @Test
    public void testEmptyJarArchive() throws Exception {
        this.checkEmptyArchive("jar");
    }

    @Test
    public void testEmptyZipArchive() throws Exception {
        this.checkEmptyArchive("zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEmptyArchive(String type) throws Exception {
        File ar = this.createEmptyArchive(type);
        ar.deleteOnExit();
        ArchiveInputStream ais = null;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(ar));
            ais = this.factory.createArchiveInputStream((InputStream)in);
        }
        catch (ArchiveException ae) {
            Assert.fail((String)("Should have recognized empty archive for " + type));
        }
        finally {
            if (ais != null) {
                ais.close();
            } else if (in != null) {
                in.close();
            }
        }
    }
}

