/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Random;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.junit.Assert;
import org.junit.Test;

public class BigFilesIT {
    @Test
    public void readFileBiggerThan8GByteStar() throws Exception {
        this.readFileBiggerThan8GByte("/8.star.tar.gz");
    }

    @Test
    public void readFileBiggerThan8GBytePosix() throws Exception {
        this.readFileBiggerThan8GByte("/8.posix.tar.gz");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readFileHeadersOfArchiveBiggerThan8GByte() throws Exception {
        BufferedInputStream in = null;
        GzipCompressorInputStream gzin = null;
        TarArchiveInputStream tin = null;
        try {
            in = new BufferedInputStream(BigFilesIT.class.getResourceAsStream("/8.posix.tar.gz"));
            gzin = new GzipCompressorInputStream((InputStream)in);
            tin = new TarArchiveInputStream((InputStream)gzin);
            TarArchiveEntry e = tin.getNextTarEntry();
            Assert.assertNotNull((Object)e);
            Assert.assertNull((Object)tin.getNextTarEntry());
        }
        finally {
            if (tin != null) {
                tin.close();
            }
            if (gzin != null) {
                gzin.close();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFileBiggerThan8GByte(String name) throws Exception {
        BufferedInputStream in = null;
        GzipCompressorInputStream gzin = null;
        TarArchiveInputStream tin = null;
        try {
            int readNow;
            in = new BufferedInputStream(BigFilesIT.class.getResourceAsStream(name));
            gzin = new GzipCompressorInputStream((InputStream)in);
            tin = new TarArchiveInputStream((InputStream)gzin);
            TarArchiveEntry e = tin.getNextTarEntry();
            Assert.assertNotNull((Object)e);
            Assert.assertEquals((long)0x200800000L, (long)e.getSize());
            long read = 0L;
            Random r = new Random(System.currentTimeMillis());
            byte[] buf = new byte[0x100000];
            while ((readNow = tin.read(buf, 0, buf.length)) > 0) {
                for (int i = 0; i < 100; ++i) {
                    int idx = r.nextInt(readNow);
                    Assert.assertEquals((String)("testing byte " + (read + (long)idx)), (long)0L, (long)buf[idx]);
                }
                read += (long)readNow;
            }
            Assert.assertEquals((long)0x200800000L, (long)read);
            Assert.assertNull((Object)tin.getNextTarEntry());
        }
        finally {
            if (tin != null) {
                tin.close();
            }
            if (gzin != null) {
                gzin.close();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }
}

