/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorOutputStream;
import org.apache.commons.compress.compressors.deflate.DeflateParameters;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Test;

public final class DeflateTestCase
extends AbstractTestCase {
    @Test
    public void testDeflateCreation() throws Exception {
        File input = DeflateTestCase.getFile("test1.xml");
        File output = new File(this.dir, "test1.xml.deflatez");
        try (FileOutputStream out = new FileOutputStream(output);
             CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("deflate", (OutputStream)out);){
            IOUtils.copy((InputStream)new FileInputStream(input), (OutputStream)cos);
        }
    }

    @Test
    public void testRawDeflateCreation() throws Exception {
        File input = DeflateTestCase.getFile("test1.xml");
        File output = new File(this.dir, "test1.xml.deflate");
        try (FileOutputStream out = new FileOutputStream(output);){
            DeflateParameters params = new DeflateParameters();
            params.setWithZlibHeader(false);
            try (DeflateCompressorOutputStream cos = new DeflateCompressorOutputStream((OutputStream)out, params);){
                IOUtils.copy((InputStream)new FileInputStream(input), (OutputStream)cos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeflateUnarchive() throws Exception {
        File input = DeflateTestCase.getFile("bla.tar.deflatez");
        File output = new File(this.dir, "bla.tar");
        try (FileInputStream is = new FileInputStream(input);){
            CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("deflate", (InputStream)is);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(output);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRawDeflateUnarchive() throws Exception {
        File input = DeflateTestCase.getFile("bla.tar.deflate");
        File output = new File(this.dir, "bla.tar");
        try (FileInputStream is = new FileInputStream(input);){
            DeflateParameters params = new DeflateParameters();
            params.setWithZlibHeader(false);
            DeflateCompressorInputStream in = new DeflateCompressorInputStream((InputStream)is, params);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(output);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                in.close();
            }
        }
    }
}

