/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.junit.Assert;
import org.junit.Test;

public class GzipUtilsTestCase {
    @Test
    public void testIsCompressedFilename() {
        Assert.assertFalse((boolean)GzipUtils.isCompressedFilename((String)""));
        Assert.assertFalse((boolean)GzipUtils.isCompressedFilename((String)".gz"));
        Assert.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.tgz"));
        Assert.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.taz"));
        Assert.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.svgz"));
        Assert.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.cpgz"));
        Assert.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.wmz"));
        Assert.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.emz"));
        Assert.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.gz"));
        Assert.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.z"));
        Assert.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x-gz"));
        Assert.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x-z"));
        Assert.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x_z"));
        Assert.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"xxgz"));
        Assert.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"xzz"));
        Assert.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"xaz"));
        Assert.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.SVGZ"));
        Assert.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.Svgz"));
        Assert.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.svGZ"));
        Assert.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"x.wmz "));
        Assert.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"x.wmz\n"));
        Assert.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"x.wmz.y"));
    }

    @Test
    public void testGetUncompressedFilename() {
        Assert.assertEquals((Object)"", (Object)GzipUtils.getUncompressedFilename((String)""));
        Assert.assertEquals((Object)".gz", (Object)GzipUtils.getUncompressedFilename((String)".gz"));
        Assert.assertEquals((Object)"x.tar", (Object)GzipUtils.getUncompressedFilename((String)"x.tgz"));
        Assert.assertEquals((Object)"x.tar", (Object)GzipUtils.getUncompressedFilename((String)"x.taz"));
        Assert.assertEquals((Object)"x.svg", (Object)GzipUtils.getUncompressedFilename((String)"x.svgz"));
        Assert.assertEquals((Object)"x.cpio", (Object)GzipUtils.getUncompressedFilename((String)"x.cpgz"));
        Assert.assertEquals((Object)"x.wmf", (Object)GzipUtils.getUncompressedFilename((String)"x.wmz"));
        Assert.assertEquals((Object)"x.emf", (Object)GzipUtils.getUncompressedFilename((String)"x.emz"));
        Assert.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFilename((String)"x.gz"));
        Assert.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFilename((String)"x.z"));
        Assert.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFilename((String)"x-gz"));
        Assert.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFilename((String)"x-z"));
        Assert.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFilename((String)"x_z"));
        Assert.assertEquals((Object)"x.svg", (Object)GzipUtils.getUncompressedFilename((String)"x.SVGZ"));
        Assert.assertEquals((Object)"X.svg", (Object)GzipUtils.getUncompressedFilename((String)"X.SVGZ"));
        Assert.assertEquals((Object)"X.svg", (Object)GzipUtils.getUncompressedFilename((String)"X.svGZ"));
        Assert.assertEquals((Object)"x.wmz ", (Object)GzipUtils.getUncompressedFilename((String)"x.wmz "));
        Assert.assertEquals((Object)"x.wmz\n", (Object)GzipUtils.getUncompressedFilename((String)"x.wmz\n"));
        Assert.assertEquals((Object)"x.wmz.y", (Object)GzipUtils.getUncompressedFilename((String)"x.wmz.y"));
    }

    @Test
    public void testGetCompressedFilename() {
        Assert.assertEquals((Object)".gz", (Object)GzipUtils.getCompressedFilename((String)""));
        Assert.assertEquals((Object)"x.gz", (Object)GzipUtils.getCompressedFilename((String)"x"));
        Assert.assertEquals((Object)"x.tgz", (Object)GzipUtils.getCompressedFilename((String)"x.tar"));
        Assert.assertEquals((Object)"x.svgz", (Object)GzipUtils.getCompressedFilename((String)"x.svg"));
        Assert.assertEquals((Object)"x.cpgz", (Object)GzipUtils.getCompressedFilename((String)"x.cpio"));
        Assert.assertEquals((Object)"x.wmz", (Object)GzipUtils.getCompressedFilename((String)"x.wmf"));
        Assert.assertEquals((Object)"x.emz", (Object)GzipUtils.getCompressedFilename((String)"x.emf"));
        Assert.assertEquals((Object)"x.svgz", (Object)GzipUtils.getCompressedFilename((String)"x.SVG"));
        Assert.assertEquals((Object)"X.svgz", (Object)GzipUtils.getCompressedFilename((String)"X.SVG"));
        Assert.assertEquals((Object)"X.svgz", (Object)GzipUtils.getCompressedFilename((String)"X.svG"));
        Assert.assertEquals((Object)"x.wmf .gz", (Object)GzipUtils.getCompressedFilename((String)"x.wmf "));
        Assert.assertEquals((Object)"x.wmf\n.gz", (Object)GzipUtils.getCompressedFilename((String)"x.wmf\n"));
        Assert.assertEquals((Object)"x.wmf.y.gz", (Object)GzipUtils.getCompressedFilename((String)"x.wmf.y"));
    }
}

