/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.xz;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class XZCompressorInputStreamTest {
    @Test
    public void redundantTestOfAlmostDeprecatedMatchesMethod() {
        byte[] data = new byte[]{-3, 55, 122, 88, 90, 0};
        Assert.assertFalse((boolean)XZCompressorInputStream.matches((byte[])data, (int)5));
        Assert.assertTrue((boolean)XZCompressorInputStream.matches((byte[])data, (int)6));
        Assert.assertTrue((boolean)XZCompressorInputStream.matches((byte[])data, (int)7));
        data[5] = 48;
        Assert.assertFalse((boolean)XZCompressorInputStream.matches((byte[])data, (int)6));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofNoDecompressConcatenated() throws IOException {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(false);
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofDecompressConcatenated() throws IOException {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(true);
    }

    private void singleByteReadConsistentlyReturnsMinusOneAtEof(boolean decompressConcatenated) throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.xz");
        try (FileInputStream is = new FileInputStream(input);){
            XZCompressorInputStream in = new XZCompressorInputStream((InputStream)is, decompressConcatenated);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofNoDecompressConcatenated() throws IOException {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(false);
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofDecompressConcatenated() throws IOException {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(true);
    }

    private void multiByteReadConsistentlyReturnsMinusOneAtEof(boolean decompressConcatenated) throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.xz");
        byte[] buf = new byte[2];
        try (FileInputStream is = new FileInputStream(input);){
            XZCompressorInputStream in = new XZCompressorInputStream((InputStream)is, decompressConcatenated);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            in.close();
        }
    }
}

