/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.comparators.ComparableComparator;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.CollatingIterator;

public class CollatingIteratorTest
extends AbstractIteratorTest<Integer> {
    private Comparator<Integer> comparator = null;
    private ArrayList<Integer> evens = null;
    private ArrayList<Integer> odds = null;
    private ArrayList<Integer> fib = null;

    public CollatingIteratorTest(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.comparator = new ComparableComparator();
        this.evens = new ArrayList();
        this.odds = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            if (0 == i % 2) {
                this.evens.add(i);
                continue;
            }
            this.odds.add(i);
        }
        this.fib = new ArrayList();
        this.fib.add(1);
        this.fib.add(1);
        this.fib.add(2);
        this.fib.add(3);
        this.fib.add(5);
        this.fib.add(8);
        this.fib.add(13);
        this.fib.add(21);
    }

    @Override
    public CollatingIterator<Integer> makeEmptyIterator() {
        return new CollatingIterator(this.comparator);
    }

    @Override
    public CollatingIterator<Integer> makeObject() {
        CollatingIterator iter = new CollatingIterator(this.comparator);
        iter.addIterator(this.evens.iterator());
        iter.addIterator(this.odds.iterator());
        iter.addIterator(this.fib.iterator());
        return iter;
    }

    public void testGetSetComparator() {
        CollatingIterator iter = new CollatingIterator();
        CollatingIteratorTest.assertNull((Object)iter.getComparator());
        iter.setComparator(this.comparator);
        CollatingIteratorTest.assertSame(this.comparator, (Object)iter.getComparator());
        iter.setComparator(null);
        CollatingIteratorTest.assertNull((Object)iter.getComparator());
    }

    public void testIterateEven() {
        CollatingIterator iter = new CollatingIterator(this.comparator);
        iter.addIterator(this.evens.iterator());
        for (int i = 0; i < this.evens.size(); ++i) {
            CollatingIteratorTest.assertTrue((boolean)iter.hasNext());
            CollatingIteratorTest.assertEquals((Object)this.evens.get(i), (Object)iter.next());
            CollatingIteratorTest.assertEquals((int)0, (int)iter.getIteratorIndex());
        }
        CollatingIteratorTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    public void testIterateEvenOdd() {
        CollatingIterator iter = new CollatingIterator(this.comparator, this.evens.iterator(), this.odds.iterator());
        for (int i = 0; i < 20; ++i) {
            CollatingIteratorTest.assertTrue((boolean)iter.hasNext());
            CollatingIteratorTest.assertEquals((Object)i, (Object)iter.next());
            CollatingIteratorTest.assertEquals((int)(i % 2), (int)iter.getIteratorIndex());
        }
        CollatingIteratorTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    public void testIterateOddEven() {
        CollatingIterator iter = new CollatingIterator(this.comparator, this.odds.iterator(), this.evens.iterator());
        for (int i = 0; i < 20; ++i) {
            CollatingIteratorTest.assertTrue((boolean)iter.hasNext());
            CollatingIteratorTest.assertEquals((Object)i, (Object)iter.next());
            CollatingIteratorTest.assertEquals((int)(i % 2 == 0 ? 1 : 0), (int)iter.getIteratorIndex());
        }
        CollatingIteratorTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    public void testIterateEvenEven() {
        CollatingIterator iter = new CollatingIterator(this.comparator);
        iter.addIterator(this.evens.iterator());
        iter.addIterator(this.evens.iterator());
        for (int i = 0; i < this.evens.size(); ++i) {
            CollatingIteratorTest.assertTrue((boolean)iter.hasNext());
            CollatingIteratorTest.assertEquals((Object)this.evens.get(i), (Object)iter.next());
            CollatingIteratorTest.assertEquals((int)0, (int)iter.getIteratorIndex());
            CollatingIteratorTest.assertTrue((boolean)iter.hasNext());
            CollatingIteratorTest.assertEquals((Object)this.evens.get(i), (Object)iter.next());
            CollatingIteratorTest.assertEquals((int)1, (int)iter.getIteratorIndex());
        }
        CollatingIteratorTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    public void testIterateFibEvenOdd() {
        CollatingIterator iter = new CollatingIterator(this.comparator);
        iter.addIterator(this.fib.iterator());
        iter.addIterator(this.evens.iterator());
        iter.addIterator(this.odds.iterator());
        CollatingIteratorTest.assertEquals((Object)0, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)1, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)1, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)0, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)1, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)0, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)1, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)2, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)2, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)0, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)2, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)1, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)3, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)0, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)3, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)2, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)4, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)1, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)5, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)0, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)5, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)2, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)6, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)1, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)7, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)2, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)8, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)0, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)8, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)1, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)9, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)2, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)10, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)1, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)11, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)2, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)12, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)1, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)13, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)0, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)13, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)2, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)14, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)1, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)15, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)2, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)16, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)1, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)17, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)2, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)18, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)1, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)19, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)2, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertEquals((Object)21, (Object)iter.next());
        CollatingIteratorTest.assertEquals((int)0, (int)iter.getIteratorIndex());
        CollatingIteratorTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    public void testRemoveFromSingle() {
        CollatingIterator iter = new CollatingIterator(this.comparator);
        iter.addIterator(this.evens.iterator());
        int expectedSize = this.evens.size();
        while (iter.hasNext()) {
            Object o = iter.next();
            Integer val = (Integer)o;
            if (val % 4 != 0) continue;
            --expectedSize;
            iter.remove();
        }
        CollatingIteratorTest.assertEquals((int)expectedSize, (int)this.evens.size());
    }

    public void testRemoveFromDouble() {
        CollatingIterator iter = new CollatingIterator(this.comparator);
        iter.addIterator(this.evens.iterator());
        iter.addIterator(this.odds.iterator());
        int expectedSize = this.evens.size() + this.odds.size();
        while (iter.hasNext()) {
            Object o = iter.next();
            Integer val = (Integer)o;
            if (val % 4 != 0 && val % 3 != 0) continue;
            --expectedSize;
            iter.remove();
        }
        CollatingIteratorTest.assertEquals((int)expectedSize, (int)(this.evens.size() + this.odds.size()));
    }

    public void testNullComparator() {
        List<Integer> l1 = Arrays.asList(1, 3, 5);
        List<Integer> l2 = Arrays.asList(2, 4, 6);
        CollatingIterator collatingIterator1 = new CollatingIterator(null, l1.iterator(), l2.iterator());
        try {
            collatingIterator1.next();
        }
        catch (NullPointerException e) {
            CollatingIteratorTest.assertTrue((boolean)e.getMessage().startsWith("You must invoke setComparator"));
        }
        int i = 0;
        CollatingIterator collatingIterator2 = new CollatingIterator(null, l1.iterator(), l2.iterator());
        collatingIterator2.setComparator((Comparator)new ComparableComparator());
        while (collatingIterator2.hasNext()) {
            Integer n = (Integer)collatingIterator2.next();
            CollatingIteratorTest.assertEquals((String)"wrong order", (int)n, (int)(i + 1));
            ++i;
        }
        CollatingIteratorTest.assertEquals((String)"wrong size", (int)i, (int)(l1.size() + l2.size()));
    }
}

