/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.map.AbstractOrderedMapTest;
import org.apache.commons.collections4.map.ListOrderedMap;

public class ListOrderedMap2Test<K, V>
extends AbstractOrderedMapTest<K, V> {
    public ListOrderedMap2Test(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(ListOrderedMap2Test.class);
    }

    @Override
    public ListOrderedMap<K, V> makeObject() {
        return new ListOrderedMap();
    }

    @Override
    public ListOrderedMap<K, V> makeFullMap() {
        return (ListOrderedMap)super.makeFullMap();
    }

    public void testGetByIndex() {
        this.resetEmpty();
        ListOrderedMap<K, V> lom = this.getMap();
        try {
            lom.get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.get(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.resetFull();
        lom = this.getMap();
        try {
            lom.get(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.get(lom.size());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        int i = 0;
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            ListOrderedMap2Test.assertSame((Object)it.next(), (Object)lom.get(i));
            ++i;
        }
    }

    public void testGetValueByIndex() {
        this.resetEmpty();
        ListOrderedMap<K, V> lom = this.getMap();
        try {
            lom.getValue(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.getValue(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.resetFull();
        lom = this.getMap();
        try {
            lom.getValue(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.getValue(lom.size());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        int i = 0;
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            it.next();
            ListOrderedMap2Test.assertSame((Object)it.getValue(), (Object)lom.getValue(i));
            ++i;
        }
    }

    public void testIndexOf() {
        this.resetEmpty();
        ListOrderedMap<K, V> lom = this.getMap();
        ListOrderedMap2Test.assertEquals((int)-1, (int)lom.indexOf(this.getOtherKeys()));
        this.resetFull();
        lom = this.getMap();
        ArrayList<Object> list = new ArrayList<Object>();
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            ListOrderedMap2Test.assertEquals((int)i, (int)lom.indexOf(list.get(i)));
        }
    }

    public void testRemoveByIndex() {
        this.resetEmpty();
        ListOrderedMap<K, V> lom = this.getMap();
        try {
            lom.remove(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.remove(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.resetFull();
        lom = this.getMap();
        try {
            lom.remove(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.remove(lom.size());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        ArrayList<Object> list = new ArrayList<Object>();
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            Object key = list.get(i);
            Object value = lom.get(key);
            ListOrderedMap2Test.assertEquals((Object)value, (Object)lom.remove(i));
            list.remove(i);
            ListOrderedMap2Test.assertEquals((boolean)false, (boolean)lom.containsKey(key));
        }
    }

    public BulkTest bulkTestListView() {
        return new TestListView();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public ListOrderedMap<K, V> getMap() {
        return (ListOrderedMap)super.getMap();
    }

    public class TestListView
    extends AbstractListTest<K> {
        TestListView() {
            super("TestListView");
        }

        @Override
        public List<K> makeObject() {
            return ListOrderedMap2Test.this.makeObject().asList();
        }

        @Override
        public List<K> makeFullCollection() {
            return ListOrderedMap2Test.this.makeFullMap().asList();
        }

        @Override
        public K[] getFullElements() {
            return ListOrderedMap2Test.this.getSampleKeys();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return false;
        }

        @Override
        public boolean isSetSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return ListOrderedMap2Test.this.isAllowNullKey();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }
    }
}

